<?php

namespace EnumType;

/**
 * This class stands for CaseStatuses EnumType
 * @subpackage Enumerations
 */
class CaseStatuses
{
    /**
     * Constant for value 'Closed'
     * @return string 'Closed'
     */
    const VALUE_CLOSED = 'Closed';
    /**
     * Constant for value 'Open'
     * @return string 'Open'
     */
    const VALUE_OPEN = 'Open';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_OPEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLOSED,
            self::VALUE_OPEN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
