<?php

namespace EnumType;

/**
 * This class stands for BankAccountTypes EnumType
 * @subpackage Enumerations
 */
class BankAccountTypes
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Savings'
     * @return string 'Savings'
     */
    const VALUE_SAVINGS = 'Savings';
    /**
     * Constant for value 'Checking'
     * @return string 'Checking'
     */
    const VALUE_CHECKING = 'Checking';
    /**
     * Constant for value 'BusinessChecking'
     * @return string 'BusinessChecking'
     */
    const VALUE_BUSINESS_CHECKING = 'BusinessChecking';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_SAVINGS
     * @uses self::VALUE_CHECKING
     * @uses self::VALUE_BUSINESS_CHECKING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_SAVINGS,
            self::VALUE_CHECKING,
            self::VALUE_BUSINESS_CHECKING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
