<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTagRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfTagRecord extends AbstractStructArrayBase
{
    /**
     * The TagRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TagRecord[]
     */
    public $TagRecord;
    /**
     * Constructor method for ArrayOfTagRecord
     * @uses ArrayOfTagRecord::setTagRecord()
     * @param \StructType\TagRecord[] $tagRecord
     */
    public function __construct(array $tagRecord = array())
    {
        $this
            ->setTagRecord($tagRecord);
    }
    /**
     * Get TagRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TagRecord[]|null
     */
    public function getTagRecord()
    {
        return isset($this->TagRecord) ? $this->TagRecord : null;
    }
    /**
     * Set TagRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TagRecord[] $tagRecord
     * @return \ArrayType\ArrayOfTagRecord
     */
    public function setTagRecord(array $tagRecord = array())
    {
        foreach ($tagRecord as $arrayOfTagRecordTagRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfTagRecordTagRecordItem instanceof \StructType\TagRecord) {
                throw new \InvalidArgumentException(sprintf('The TagRecord property can only contain items of \StructType\TagRecord, "%s" given', is_object($arrayOfTagRecordTagRecordItem) ? get_class($arrayOfTagRecordTagRecordItem) : gettype($arrayOfTagRecordTagRecordItem)), __LINE__);
            }
        }
        if (is_null($tagRecord) || (is_array($tagRecord) && empty($tagRecord))) {
            unset($this->TagRecord);
        } else {
            $this->TagRecord = $tagRecord;
        }
        return $this;
    }
    /**
     * Add item to TagRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\TagRecord $item
     * @return \ArrayType\ArrayOfTagRecord
     */
    public function addToTagRecord(\StructType\TagRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TagRecord) {
            throw new \InvalidArgumentException(sprintf('The TagRecord property can only contain items of \StructType\TagRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TagRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TagRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TagRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TagRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TagRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TagRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TagRecord
     */
    public function getAttributeName()
    {
        return 'TagRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTagRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
