<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRelationshipRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfRelationshipRecord extends AbstractStructArrayBase
{
    /**
     * The RelationshipRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RelationshipRecord[]
     */
    public $RelationshipRecord;
    /**
     * Constructor method for ArrayOfRelationshipRecord
     * @uses ArrayOfRelationshipRecord::setRelationshipRecord()
     * @param \StructType\RelationshipRecord[] $relationshipRecord
     */
    public function __construct(array $relationshipRecord = array())
    {
        $this
            ->setRelationshipRecord($relationshipRecord);
    }
    /**
     * Get RelationshipRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RelationshipRecord[]|null
     */
    public function getRelationshipRecord()
    {
        return isset($this->RelationshipRecord) ? $this->RelationshipRecord : null;
    }
    /**
     * Set RelationshipRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RelationshipRecord[] $relationshipRecord
     * @return \ArrayType\ArrayOfRelationshipRecord
     */
    public function setRelationshipRecord(array $relationshipRecord = array())
    {
        foreach ($relationshipRecord as $arrayOfRelationshipRecordRelationshipRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfRelationshipRecordRelationshipRecordItem instanceof \StructType\RelationshipRecord) {
                throw new \InvalidArgumentException(sprintf('The RelationshipRecord property can only contain items of \StructType\RelationshipRecord, "%s" given', is_object($arrayOfRelationshipRecordRelationshipRecordItem) ? get_class($arrayOfRelationshipRecordRelationshipRecordItem) : gettype($arrayOfRelationshipRecordRelationshipRecordItem)), __LINE__);
            }
        }
        if (is_null($relationshipRecord) || (is_array($relationshipRecord) && empty($relationshipRecord))) {
            unset($this->RelationshipRecord);
        } else {
            $this->RelationshipRecord = $relationshipRecord;
        }
        return $this;
    }
    /**
     * Add item to RelationshipRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\RelationshipRecord $item
     * @return \ArrayType\ArrayOfRelationshipRecord
     */
    public function addToRelationshipRecord(\StructType\RelationshipRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RelationshipRecord) {
            throw new \InvalidArgumentException(sprintf('The RelationshipRecord property can only contain items of \StructType\RelationshipRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RelationshipRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RelationshipRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RelationshipRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RelationshipRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RelationshipRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RelationshipRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RelationshipRecord
     */
    public function getAttributeName()
    {
        return 'RelationshipRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRelationshipRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
