<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNoteRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfNoteRecord extends AbstractStructArrayBase
{
    /**
     * The NoteRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NoteRecord[]
     */
    public $NoteRecord;
    /**
     * Constructor method for ArrayOfNoteRecord
     * @uses ArrayOfNoteRecord::setNoteRecord()
     * @param \StructType\NoteRecord[] $noteRecord
     */
    public function __construct(array $noteRecord = array())
    {
        $this
            ->setNoteRecord($noteRecord);
    }
    /**
     * Get NoteRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NoteRecord[]|null
     */
    public function getNoteRecord()
    {
        return isset($this->NoteRecord) ? $this->NoteRecord : null;
    }
    /**
     * Set NoteRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NoteRecord[] $noteRecord
     * @return \ArrayType\ArrayOfNoteRecord
     */
    public function setNoteRecord(array $noteRecord = array())
    {
        foreach ($noteRecord as $arrayOfNoteRecordNoteRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfNoteRecordNoteRecordItem instanceof \StructType\NoteRecord) {
                throw new \InvalidArgumentException(sprintf('The NoteRecord property can only contain items of \StructType\NoteRecord, "%s" given', is_object($arrayOfNoteRecordNoteRecordItem) ? get_class($arrayOfNoteRecordNoteRecordItem) : gettype($arrayOfNoteRecordNoteRecordItem)), __LINE__);
            }
        }
        if (is_null($noteRecord) || (is_array($noteRecord) && empty($noteRecord))) {
            unset($this->NoteRecord);
        } else {
            $this->NoteRecord = $noteRecord;
        }
        return $this;
    }
    /**
     * Add item to NoteRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\NoteRecord $item
     * @return \ArrayType\ArrayOfNoteRecord
     */
    public function addToNoteRecord(\StructType\NoteRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NoteRecord) {
            throw new \InvalidArgumentException(sprintf('The NoteRecord property can only contain items of \StructType\NoteRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NoteRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\NoteRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\NoteRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\NoteRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\NoteRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\NoteRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NoteRecord
     */
    public function getAttributeName()
    {
        return 'NoteRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfNoteRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
