<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGroupRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfGroupRecord extends AbstractStructArrayBase
{
    /**
     * The GroupRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GroupRecord[]
     */
    public $GroupRecord;
    /**
     * Constructor method for ArrayOfGroupRecord
     * @uses ArrayOfGroupRecord::setGroupRecord()
     * @param \StructType\GroupRecord[] $groupRecord
     */
    public function __construct(array $groupRecord = array())
    {
        $this
            ->setGroupRecord($groupRecord);
    }
    /**
     * Get GroupRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GroupRecord[]|null
     */
    public function getGroupRecord()
    {
        return isset($this->GroupRecord) ? $this->GroupRecord : null;
    }
    /**
     * Set GroupRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GroupRecord[] $groupRecord
     * @return \ArrayType\ArrayOfGroupRecord
     */
    public function setGroupRecord(array $groupRecord = array())
    {
        foreach ($groupRecord as $arrayOfGroupRecordGroupRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfGroupRecordGroupRecordItem instanceof \StructType\GroupRecord) {
                throw new \InvalidArgumentException(sprintf('The GroupRecord property can only contain items of \StructType\GroupRecord, "%s" given', is_object($arrayOfGroupRecordGroupRecordItem) ? get_class($arrayOfGroupRecordGroupRecordItem) : gettype($arrayOfGroupRecordGroupRecordItem)), __LINE__);
            }
        }
        if (is_null($groupRecord) || (is_array($groupRecord) && empty($groupRecord))) {
            unset($this->GroupRecord);
        } else {
            $this->GroupRecord = $groupRecord;
        }
        return $this;
    }
    /**
     * Add item to GroupRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\GroupRecord $item
     * @return \ArrayType\ArrayOfGroupRecord
     */
    public function addToGroupRecord(\StructType\GroupRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GroupRecord) {
            throw new \InvalidArgumentException(sprintf('The GroupRecord property can only contain items of \StructType\GroupRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GroupRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GroupRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GroupRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GroupRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GroupRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GroupRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GroupRecord
     */
    public function getAttributeName()
    {
        return 'GroupRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfGroupRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
