<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFindOrCreateContactParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfFindOrCreateContactParameters extends AbstractStructArrayBase
{
    /**
     * The FindOrCreateContactParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FindOrCreateContactParameters[]
     */
    public $FindOrCreateContactParameters;
    /**
     * Constructor method for ArrayOfFindOrCreateContactParameters
     * @uses ArrayOfFindOrCreateContactParameters::setFindOrCreateContactParameters()
     * @param \StructType\FindOrCreateContactParameters[] $findOrCreateContactParameters
     */
    public function __construct(array $findOrCreateContactParameters = array())
    {
        $this
            ->setFindOrCreateContactParameters($findOrCreateContactParameters);
    }
    /**
     * Get FindOrCreateContactParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FindOrCreateContactParameters[]|null
     */
    public function getFindOrCreateContactParameters()
    {
        return isset($this->FindOrCreateContactParameters) ? $this->FindOrCreateContactParameters : null;
    }
    /**
     * Set FindOrCreateContactParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FindOrCreateContactParameters[] $findOrCreateContactParameters
     * @return \ArrayType\ArrayOfFindOrCreateContactParameters
     */
    public function setFindOrCreateContactParameters(array $findOrCreateContactParameters = array())
    {
        foreach ($findOrCreateContactParameters as $arrayOfFindOrCreateContactParametersFindOrCreateContactParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfFindOrCreateContactParametersFindOrCreateContactParametersItem instanceof \StructType\FindOrCreateContactParameters) {
                throw new \InvalidArgumentException(sprintf('The FindOrCreateContactParameters property can only contain items of \StructType\FindOrCreateContactParameters, "%s" given', is_object($arrayOfFindOrCreateContactParametersFindOrCreateContactParametersItem) ? get_class($arrayOfFindOrCreateContactParametersFindOrCreateContactParametersItem) : gettype($arrayOfFindOrCreateContactParametersFindOrCreateContactParametersItem)), __LINE__);
            }
        }
        if (is_null($findOrCreateContactParameters) || (is_array($findOrCreateContactParameters) && empty($findOrCreateContactParameters))) {
            unset($this->FindOrCreateContactParameters);
        } else {
            $this->FindOrCreateContactParameters = $findOrCreateContactParameters;
        }
        return $this;
    }
    /**
     * Add item to FindOrCreateContactParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\FindOrCreateContactParameters $item
     * @return \ArrayType\ArrayOfFindOrCreateContactParameters
     */
    public function addToFindOrCreateContactParameters(\StructType\FindOrCreateContactParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FindOrCreateContactParameters) {
            throw new \InvalidArgumentException(sprintf('The FindOrCreateContactParameters property can only contain items of \StructType\FindOrCreateContactParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FindOrCreateContactParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FindOrCreateContactParameters
     */
    public function getAttributeName()
    {
        return 'FindOrCreateContactParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfFindOrCreateContactParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
