<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFileRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfFileRecord extends AbstractStructArrayBase
{
    /**
     * The FileRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FileRecord[]
     */
    public $FileRecord;
    /**
     * Constructor method for ArrayOfFileRecord
     * @uses ArrayOfFileRecord::setFileRecord()
     * @param \StructType\FileRecord[] $fileRecord
     */
    public function __construct(array $fileRecord = array())
    {
        $this
            ->setFileRecord($fileRecord);
    }
    /**
     * Get FileRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FileRecord[]|null
     */
    public function getFileRecord()
    {
        return isset($this->FileRecord) ? $this->FileRecord : null;
    }
    /**
     * Set FileRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FileRecord[] $fileRecord
     * @return \ArrayType\ArrayOfFileRecord
     */
    public function setFileRecord(array $fileRecord = array())
    {
        foreach ($fileRecord as $arrayOfFileRecordFileRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfFileRecordFileRecordItem instanceof \StructType\FileRecord) {
                throw new \InvalidArgumentException(sprintf('The FileRecord property can only contain items of \StructType\FileRecord, "%s" given', is_object($arrayOfFileRecordFileRecordItem) ? get_class($arrayOfFileRecordFileRecordItem) : gettype($arrayOfFileRecordFileRecordItem)), __LINE__);
            }
        }
        if (is_null($fileRecord) || (is_array($fileRecord) && empty($fileRecord))) {
            unset($this->FileRecord);
        } else {
            $this->FileRecord = $fileRecord;
        }
        return $this;
    }
    /**
     * Add item to FileRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\FileRecord $item
     * @return \ArrayType\ArrayOfFileRecord
     */
    public function addToFileRecord(\StructType\FileRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FileRecord) {
            throw new \InvalidArgumentException(sprintf('The FileRecord property can only contain items of \StructType\FileRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FileRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FileRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FileRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FileRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FileRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FileRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FileRecord
     */
    public function getAttributeName()
    {
        return 'FileRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfFileRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
