<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEditRelationshipResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfEditRelationshipResponse extends AbstractStructArrayBase
{
    /**
     * The EditRelationshipResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EditRelationshipResponse[]
     */
    public $EditRelationshipResponse;
    /**
     * Constructor method for ArrayOfEditRelationshipResponse
     * @uses ArrayOfEditRelationshipResponse::setEditRelationshipResponse()
     * @param \StructType\EditRelationshipResponse[] $editRelationshipResponse
     */
    public function __construct(array $editRelationshipResponse = array())
    {
        $this
            ->setEditRelationshipResponse($editRelationshipResponse);
    }
    /**
     * Get EditRelationshipResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EditRelationshipResponse[]|null
     */
    public function getEditRelationshipResponse()
    {
        return isset($this->EditRelationshipResponse) ? $this->EditRelationshipResponse : null;
    }
    /**
     * Set EditRelationshipResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EditRelationshipResponse[] $editRelationshipResponse
     * @return \ArrayType\ArrayOfEditRelationshipResponse
     */
    public function setEditRelationshipResponse(array $editRelationshipResponse = array())
    {
        foreach ($editRelationshipResponse as $arrayOfEditRelationshipResponseEditRelationshipResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfEditRelationshipResponseEditRelationshipResponseItem instanceof \StructType\EditRelationshipResponse) {
                throw new \InvalidArgumentException(sprintf('The EditRelationshipResponse property can only contain items of \StructType\EditRelationshipResponse, "%s" given', is_object($arrayOfEditRelationshipResponseEditRelationshipResponseItem) ? get_class($arrayOfEditRelationshipResponseEditRelationshipResponseItem) : gettype($arrayOfEditRelationshipResponseEditRelationshipResponseItem)), __LINE__);
            }
        }
        if (is_null($editRelationshipResponse) || (is_array($editRelationshipResponse) && empty($editRelationshipResponse))) {
            unset($this->EditRelationshipResponse);
        } else {
            $this->EditRelationshipResponse = $editRelationshipResponse;
        }
        return $this;
    }
    /**
     * Add item to EditRelationshipResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\EditRelationshipResponse $item
     * @return \ArrayType\ArrayOfEditRelationshipResponse
     */
    public function addToEditRelationshipResponse(\StructType\EditRelationshipResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditRelationshipResponse) {
            throw new \InvalidArgumentException(sprintf('The EditRelationshipResponse property can only contain items of \StructType\EditRelationshipResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EditRelationshipResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EditRelationshipResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EditRelationshipResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EditRelationshipResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EditRelationshipResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EditRelationshipResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EditRelationshipResponse
     */
    public function getAttributeName()
    {
        return 'EditRelationshipResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEditRelationshipResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
