<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEditPersonParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfEditPersonParameters extends AbstractStructArrayBase
{
    /**
     * The EditPersonParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EditPersonParameters[]
     */
    public $EditPersonParameters;
    /**
     * Constructor method for ArrayOfEditPersonParameters
     * @uses ArrayOfEditPersonParameters::setEditPersonParameters()
     * @param \StructType\EditPersonParameters[] $editPersonParameters
     */
    public function __construct(array $editPersonParameters = array())
    {
        $this
            ->setEditPersonParameters($editPersonParameters);
    }
    /**
     * Get EditPersonParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EditPersonParameters[]|null
     */
    public function getEditPersonParameters()
    {
        return isset($this->EditPersonParameters) ? $this->EditPersonParameters : null;
    }
    /**
     * Set EditPersonParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EditPersonParameters[] $editPersonParameters
     * @return \ArrayType\ArrayOfEditPersonParameters
     */
    public function setEditPersonParameters(array $editPersonParameters = array())
    {
        foreach ($editPersonParameters as $arrayOfEditPersonParametersEditPersonParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfEditPersonParametersEditPersonParametersItem instanceof \StructType\EditPersonParameters) {
                throw new \InvalidArgumentException(sprintf('The EditPersonParameters property can only contain items of \StructType\EditPersonParameters, "%s" given', is_object($arrayOfEditPersonParametersEditPersonParametersItem) ? get_class($arrayOfEditPersonParametersEditPersonParametersItem) : gettype($arrayOfEditPersonParametersEditPersonParametersItem)), __LINE__);
            }
        }
        if (is_null($editPersonParameters) || (is_array($editPersonParameters) && empty($editPersonParameters))) {
            unset($this->EditPersonParameters);
        } else {
            $this->EditPersonParameters = $editPersonParameters;
        }
        return $this;
    }
    /**
     * Add item to EditPersonParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\EditPersonParameters $item
     * @return \ArrayType\ArrayOfEditPersonParameters
     */
    public function addToEditPersonParameters(\StructType\EditPersonParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditPersonParameters) {
            throw new \InvalidArgumentException(sprintf('The EditPersonParameters property can only contain items of \StructType\EditPersonParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EditPersonParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EditPersonParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EditPersonParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EditPersonParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EditPersonParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EditPersonParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EditPersonParameters
     */
    public function getAttributeName()
    {
        return 'EditPersonParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEditPersonParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
