<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEditFileResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfEditFileResponse extends AbstractStructArrayBase
{
    /**
     * The EditFileResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EditFileResponse[]
     */
    public $EditFileResponse;
    /**
     * Constructor method for ArrayOfEditFileResponse
     * @uses ArrayOfEditFileResponse::setEditFileResponse()
     * @param \StructType\EditFileResponse[] $editFileResponse
     */
    public function __construct(array $editFileResponse = array())
    {
        $this
            ->setEditFileResponse($editFileResponse);
    }
    /**
     * Get EditFileResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EditFileResponse[]|null
     */
    public function getEditFileResponse()
    {
        return isset($this->EditFileResponse) ? $this->EditFileResponse : null;
    }
    /**
     * Set EditFileResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EditFileResponse[] $editFileResponse
     * @return \ArrayType\ArrayOfEditFileResponse
     */
    public function setEditFileResponse(array $editFileResponse = array())
    {
        foreach ($editFileResponse as $arrayOfEditFileResponseEditFileResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfEditFileResponseEditFileResponseItem instanceof \StructType\EditFileResponse) {
                throw new \InvalidArgumentException(sprintf('The EditFileResponse property can only contain items of \StructType\EditFileResponse, "%s" given', is_object($arrayOfEditFileResponseEditFileResponseItem) ? get_class($arrayOfEditFileResponseEditFileResponseItem) : gettype($arrayOfEditFileResponseEditFileResponseItem)), __LINE__);
            }
        }
        if (is_null($editFileResponse) || (is_array($editFileResponse) && empty($editFileResponse))) {
            unset($this->EditFileResponse);
        } else {
            $this->EditFileResponse = $editFileResponse;
        }
        return $this;
    }
    /**
     * Add item to EditFileResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\EditFileResponse $item
     * @return \ArrayType\ArrayOfEditFileResponse
     */
    public function addToEditFileResponse(\StructType\EditFileResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditFileResponse) {
            throw new \InvalidArgumentException(sprintf('The EditFileResponse property can only contain items of \StructType\EditFileResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EditFileResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EditFileResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EditFileResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EditFileResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EditFileResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EditFileResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EditFileResponse
     */
    public function getAttributeName()
    {
        return 'EditFileResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEditFileResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
