<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEditAddressResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfEditAddressResponse extends AbstractStructArrayBase
{
    /**
     * The EditAddressResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EditAddressResponse[]
     */
    public $EditAddressResponse;
    /**
     * Constructor method for ArrayOfEditAddressResponse
     * @uses ArrayOfEditAddressResponse::setEditAddressResponse()
     * @param \StructType\EditAddressResponse[] $editAddressResponse
     */
    public function __construct(array $editAddressResponse = array())
    {
        $this
            ->setEditAddressResponse($editAddressResponse);
    }
    /**
     * Get EditAddressResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EditAddressResponse[]|null
     */
    public function getEditAddressResponse()
    {
        return isset($this->EditAddressResponse) ? $this->EditAddressResponse : null;
    }
    /**
     * Set EditAddressResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EditAddressResponse[] $editAddressResponse
     * @return \ArrayType\ArrayOfEditAddressResponse
     */
    public function setEditAddressResponse(array $editAddressResponse = array())
    {
        foreach ($editAddressResponse as $arrayOfEditAddressResponseEditAddressResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfEditAddressResponseEditAddressResponseItem instanceof \StructType\EditAddressResponse) {
                throw new \InvalidArgumentException(sprintf('The EditAddressResponse property can only contain items of \StructType\EditAddressResponse, "%s" given', is_object($arrayOfEditAddressResponseEditAddressResponseItem) ? get_class($arrayOfEditAddressResponseEditAddressResponseItem) : gettype($arrayOfEditAddressResponseEditAddressResponseItem)), __LINE__);
            }
        }
        if (is_null($editAddressResponse) || (is_array($editAddressResponse) && empty($editAddressResponse))) {
            unset($this->EditAddressResponse);
        } else {
            $this->EditAddressResponse = $editAddressResponse;
        }
        return $this;
    }
    /**
     * Add item to EditAddressResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\EditAddressResponse $item
     * @return \ArrayType\ArrayOfEditAddressResponse
     */
    public function addToEditAddressResponse(\StructType\EditAddressResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditAddressResponse) {
            throw new \InvalidArgumentException(sprintf('The EditAddressResponse property can only contain items of \StructType\EditAddressResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EditAddressResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EditAddressResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EditAddressResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EditAddressResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EditAddressResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EditAddressResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EditAddressResponse
     */
    public function getAttributeName()
    {
        return 'EditAddressResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEditAddressResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
