<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEditAddressParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfEditAddressParameters extends AbstractStructArrayBase
{
    /**
     * The EditAddressParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EditAddressParameters[]
     */
    public $EditAddressParameters;
    /**
     * Constructor method for ArrayOfEditAddressParameters
     * @uses ArrayOfEditAddressParameters::setEditAddressParameters()
     * @param \StructType\EditAddressParameters[] $editAddressParameters
     */
    public function __construct(array $editAddressParameters = array())
    {
        $this
            ->setEditAddressParameters($editAddressParameters);
    }
    /**
     * Get EditAddressParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EditAddressParameters[]|null
     */
    public function getEditAddressParameters()
    {
        return isset($this->EditAddressParameters) ? $this->EditAddressParameters : null;
    }
    /**
     * Set EditAddressParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EditAddressParameters[] $editAddressParameters
     * @return \ArrayType\ArrayOfEditAddressParameters
     */
    public function setEditAddressParameters(array $editAddressParameters = array())
    {
        foreach ($editAddressParameters as $arrayOfEditAddressParametersEditAddressParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfEditAddressParametersEditAddressParametersItem instanceof \StructType\EditAddressParameters) {
                throw new \InvalidArgumentException(sprintf('The EditAddressParameters property can only contain items of \StructType\EditAddressParameters, "%s" given', is_object($arrayOfEditAddressParametersEditAddressParametersItem) ? get_class($arrayOfEditAddressParametersEditAddressParametersItem) : gettype($arrayOfEditAddressParametersEditAddressParametersItem)), __LINE__);
            }
        }
        if (is_null($editAddressParameters) || (is_array($editAddressParameters) && empty($editAddressParameters))) {
            unset($this->EditAddressParameters);
        } else {
            $this->EditAddressParameters = $editAddressParameters;
        }
        return $this;
    }
    /**
     * Add item to EditAddressParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\EditAddressParameters $item
     * @return \ArrayType\ArrayOfEditAddressParameters
     */
    public function addToEditAddressParameters(\StructType\EditAddressParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditAddressParameters) {
            throw new \InvalidArgumentException(sprintf('The EditAddressParameters property can only contain items of \StructType\EditAddressParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EditAddressParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EditAddressParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EditAddressParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EditAddressParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EditAddressParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EditAddressParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EditAddressParameters
     */
    public function getAttributeName()
    {
        return 'EditAddressParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEditAddressParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
