<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEditActivityResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfEditActivityResponse extends AbstractStructArrayBase
{
    /**
     * The EditActivityResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EditActivityResponse[]
     */
    public $EditActivityResponse;
    /**
     * Constructor method for ArrayOfEditActivityResponse
     * @uses ArrayOfEditActivityResponse::setEditActivityResponse()
     * @param \StructType\EditActivityResponse[] $editActivityResponse
     */
    public function __construct(array $editActivityResponse = array())
    {
        $this
            ->setEditActivityResponse($editActivityResponse);
    }
    /**
     * Get EditActivityResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EditActivityResponse[]|null
     */
    public function getEditActivityResponse()
    {
        return isset($this->EditActivityResponse) ? $this->EditActivityResponse : null;
    }
    /**
     * Set EditActivityResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EditActivityResponse[] $editActivityResponse
     * @return \ArrayType\ArrayOfEditActivityResponse
     */
    public function setEditActivityResponse(array $editActivityResponse = array())
    {
        foreach ($editActivityResponse as $arrayOfEditActivityResponseEditActivityResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfEditActivityResponseEditActivityResponseItem instanceof \StructType\EditActivityResponse) {
                throw new \InvalidArgumentException(sprintf('The EditActivityResponse property can only contain items of \StructType\EditActivityResponse, "%s" given', is_object($arrayOfEditActivityResponseEditActivityResponseItem) ? get_class($arrayOfEditActivityResponseEditActivityResponseItem) : gettype($arrayOfEditActivityResponseEditActivityResponseItem)), __LINE__);
            }
        }
        if (is_null($editActivityResponse) || (is_array($editActivityResponse) && empty($editActivityResponse))) {
            unset($this->EditActivityResponse);
        } else {
            $this->EditActivityResponse = $editActivityResponse;
        }
        return $this;
    }
    /**
     * Add item to EditActivityResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\EditActivityResponse $item
     * @return \ArrayType\ArrayOfEditActivityResponse
     */
    public function addToEditActivityResponse(\StructType\EditActivityResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditActivityResponse) {
            throw new \InvalidArgumentException(sprintf('The EditActivityResponse property can only contain items of \StructType\EditActivityResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EditActivityResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EditActivityResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EditActivityResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EditActivityResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EditActivityResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EditActivityResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EditActivityResponse
     */
    public function getAttributeName()
    {
        return 'EditActivityResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEditActivityResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
