<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEditActivityParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfEditActivityParameters extends AbstractStructArrayBase
{
    /**
     * The EditActivityParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EditActivityParameters[]
     */
    public $EditActivityParameters;
    /**
     * Constructor method for ArrayOfEditActivityParameters
     * @uses ArrayOfEditActivityParameters::setEditActivityParameters()
     * @param \StructType\EditActivityParameters[] $editActivityParameters
     */
    public function __construct(array $editActivityParameters = array())
    {
        $this
            ->setEditActivityParameters($editActivityParameters);
    }
    /**
     * Get EditActivityParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EditActivityParameters[]|null
     */
    public function getEditActivityParameters()
    {
        return isset($this->EditActivityParameters) ? $this->EditActivityParameters : null;
    }
    /**
     * Set EditActivityParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EditActivityParameters[] $editActivityParameters
     * @return \ArrayType\ArrayOfEditActivityParameters
     */
    public function setEditActivityParameters(array $editActivityParameters = array())
    {
        foreach ($editActivityParameters as $arrayOfEditActivityParametersEditActivityParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfEditActivityParametersEditActivityParametersItem instanceof \StructType\EditActivityParameters) {
                throw new \InvalidArgumentException(sprintf('The EditActivityParameters property can only contain items of \StructType\EditActivityParameters, "%s" given', is_object($arrayOfEditActivityParametersEditActivityParametersItem) ? get_class($arrayOfEditActivityParametersEditActivityParametersItem) : gettype($arrayOfEditActivityParametersEditActivityParametersItem)), __LINE__);
            }
        }
        if (is_null($editActivityParameters) || (is_array($editActivityParameters) && empty($editActivityParameters))) {
            unset($this->EditActivityParameters);
        } else {
            $this->EditActivityParameters = $editActivityParameters;
        }
        return $this;
    }
    /**
     * Add item to EditActivityParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\EditActivityParameters $item
     * @return \ArrayType\ArrayOfEditActivityParameters
     */
    public function addToEditActivityParameters(\StructType\EditActivityParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditActivityParameters) {
            throw new \InvalidArgumentException(sprintf('The EditActivityParameters property can only contain items of \StructType\EditActivityParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EditActivityParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EditActivityParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EditActivityParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EditActivityParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EditActivityParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EditActivityParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EditActivityParameters
     */
    public function getAttributeName()
    {
        return 'EditActivityParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEditActivityParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
