<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeleteWebsiteResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeleteWebsiteResponse extends AbstractStructArrayBase
{
    /**
     * The DeleteWebsiteResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeleteWebsiteResponse[]
     */
    public $DeleteWebsiteResponse;
    /**
     * Constructor method for ArrayOfDeleteWebsiteResponse
     * @uses ArrayOfDeleteWebsiteResponse::setDeleteWebsiteResponse()
     * @param \StructType\DeleteWebsiteResponse[] $deleteWebsiteResponse
     */
    public function __construct(array $deleteWebsiteResponse = array())
    {
        $this
            ->setDeleteWebsiteResponse($deleteWebsiteResponse);
    }
    /**
     * Get DeleteWebsiteResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeleteWebsiteResponse[]|null
     */
    public function getDeleteWebsiteResponse()
    {
        return isset($this->DeleteWebsiteResponse) ? $this->DeleteWebsiteResponse : null;
    }
    /**
     * Set DeleteWebsiteResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteWebsiteResponse[] $deleteWebsiteResponse
     * @return \ArrayType\ArrayOfDeleteWebsiteResponse
     */
    public function setDeleteWebsiteResponse(array $deleteWebsiteResponse = array())
    {
        foreach ($deleteWebsiteResponse as $arrayOfDeleteWebsiteResponseDeleteWebsiteResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeleteWebsiteResponseDeleteWebsiteResponseItem instanceof \StructType\DeleteWebsiteResponse) {
                throw new \InvalidArgumentException(sprintf('The DeleteWebsiteResponse property can only contain items of \StructType\DeleteWebsiteResponse, "%s" given', is_object($arrayOfDeleteWebsiteResponseDeleteWebsiteResponseItem) ? get_class($arrayOfDeleteWebsiteResponseDeleteWebsiteResponseItem) : gettype($arrayOfDeleteWebsiteResponseDeleteWebsiteResponseItem)), __LINE__);
            }
        }
        if (is_null($deleteWebsiteResponse) || (is_array($deleteWebsiteResponse) && empty($deleteWebsiteResponse))) {
            unset($this->DeleteWebsiteResponse);
        } else {
            $this->DeleteWebsiteResponse = $deleteWebsiteResponse;
        }
        return $this;
    }
    /**
     * Add item to DeleteWebsiteResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteWebsiteResponse $item
     * @return \ArrayType\ArrayOfDeleteWebsiteResponse
     */
    public function addToDeleteWebsiteResponse(\StructType\DeleteWebsiteResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteWebsiteResponse) {
            throw new \InvalidArgumentException(sprintf('The DeleteWebsiteResponse property can only contain items of \StructType\DeleteWebsiteResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeleteWebsiteResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteWebsiteResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteWebsiteResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteWebsiteResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteWebsiteResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteWebsiteResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteWebsiteResponse
     */
    public function getAttributeName()
    {
        return 'DeleteWebsiteResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeleteWebsiteResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
