<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeleteTributeResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeleteTributeResponse extends AbstractStructArrayBase
{
    /**
     * The DeleteTributeResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeleteTributeResponse[]
     */
    public $DeleteTributeResponse;
    /**
     * Constructor method for ArrayOfDeleteTributeResponse
     * @uses ArrayOfDeleteTributeResponse::setDeleteTributeResponse()
     * @param \StructType\DeleteTributeResponse[] $deleteTributeResponse
     */
    public function __construct(array $deleteTributeResponse = array())
    {
        $this
            ->setDeleteTributeResponse($deleteTributeResponse);
    }
    /**
     * Get DeleteTributeResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeleteTributeResponse[]|null
     */
    public function getDeleteTributeResponse()
    {
        return isset($this->DeleteTributeResponse) ? $this->DeleteTributeResponse : null;
    }
    /**
     * Set DeleteTributeResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteTributeResponse[] $deleteTributeResponse
     * @return \ArrayType\ArrayOfDeleteTributeResponse
     */
    public function setDeleteTributeResponse(array $deleteTributeResponse = array())
    {
        foreach ($deleteTributeResponse as $arrayOfDeleteTributeResponseDeleteTributeResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeleteTributeResponseDeleteTributeResponseItem instanceof \StructType\DeleteTributeResponse) {
                throw new \InvalidArgumentException(sprintf('The DeleteTributeResponse property can only contain items of \StructType\DeleteTributeResponse, "%s" given', is_object($arrayOfDeleteTributeResponseDeleteTributeResponseItem) ? get_class($arrayOfDeleteTributeResponseDeleteTributeResponseItem) : gettype($arrayOfDeleteTributeResponseDeleteTributeResponseItem)), __LINE__);
            }
        }
        if (is_null($deleteTributeResponse) || (is_array($deleteTributeResponse) && empty($deleteTributeResponse))) {
            unset($this->DeleteTributeResponse);
        } else {
            $this->DeleteTributeResponse = $deleteTributeResponse;
        }
        return $this;
    }
    /**
     * Add item to DeleteTributeResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteTributeResponse $item
     * @return \ArrayType\ArrayOfDeleteTributeResponse
     */
    public function addToDeleteTributeResponse(\StructType\DeleteTributeResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteTributeResponse) {
            throw new \InvalidArgumentException(sprintf('The DeleteTributeResponse property can only contain items of \StructType\DeleteTributeResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeleteTributeResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteTributeResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteTributeResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteTributeResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteTributeResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteTributeResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteTributeResponse
     */
    public function getAttributeName()
    {
        return 'DeleteTributeResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeleteTributeResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
