<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeleteSocialMediaHandleParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeleteSocialMediaHandleParameters extends AbstractStructArrayBase
{
    /**
     * The DeleteSocialMediaHandleParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeleteSocialMediaHandleParameters[]
     */
    public $DeleteSocialMediaHandleParameters;
    /**
     * Constructor method for ArrayOfDeleteSocialMediaHandleParameters
     * @uses ArrayOfDeleteSocialMediaHandleParameters::setDeleteSocialMediaHandleParameters()
     * @param \StructType\DeleteSocialMediaHandleParameters[] $deleteSocialMediaHandleParameters
     */
    public function __construct(array $deleteSocialMediaHandleParameters = array())
    {
        $this
            ->setDeleteSocialMediaHandleParameters($deleteSocialMediaHandleParameters);
    }
    /**
     * Get DeleteSocialMediaHandleParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeleteSocialMediaHandleParameters[]|null
     */
    public function getDeleteSocialMediaHandleParameters()
    {
        return isset($this->DeleteSocialMediaHandleParameters) ? $this->DeleteSocialMediaHandleParameters : null;
    }
    /**
     * Set DeleteSocialMediaHandleParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteSocialMediaHandleParameters[] $deleteSocialMediaHandleParameters
     * @return \ArrayType\ArrayOfDeleteSocialMediaHandleParameters
     */
    public function setDeleteSocialMediaHandleParameters(array $deleteSocialMediaHandleParameters = array())
    {
        foreach ($deleteSocialMediaHandleParameters as $arrayOfDeleteSocialMediaHandleParametersDeleteSocialMediaHandleParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeleteSocialMediaHandleParametersDeleteSocialMediaHandleParametersItem instanceof \StructType\DeleteSocialMediaHandleParameters) {
                throw new \InvalidArgumentException(sprintf('The DeleteSocialMediaHandleParameters property can only contain items of \StructType\DeleteSocialMediaHandleParameters, "%s" given', is_object($arrayOfDeleteSocialMediaHandleParametersDeleteSocialMediaHandleParametersItem) ? get_class($arrayOfDeleteSocialMediaHandleParametersDeleteSocialMediaHandleParametersItem) : gettype($arrayOfDeleteSocialMediaHandleParametersDeleteSocialMediaHandleParametersItem)), __LINE__);
            }
        }
        if (is_null($deleteSocialMediaHandleParameters) || (is_array($deleteSocialMediaHandleParameters) && empty($deleteSocialMediaHandleParameters))) {
            unset($this->DeleteSocialMediaHandleParameters);
        } else {
            $this->DeleteSocialMediaHandleParameters = $deleteSocialMediaHandleParameters;
        }
        return $this;
    }
    /**
     * Add item to DeleteSocialMediaHandleParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteSocialMediaHandleParameters $item
     * @return \ArrayType\ArrayOfDeleteSocialMediaHandleParameters
     */
    public function addToDeleteSocialMediaHandleParameters(\StructType\DeleteSocialMediaHandleParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteSocialMediaHandleParameters) {
            throw new \InvalidArgumentException(sprintf('The DeleteSocialMediaHandleParameters property can only contain items of \StructType\DeleteSocialMediaHandleParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeleteSocialMediaHandleParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteSocialMediaHandleParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteSocialMediaHandleParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteSocialMediaHandleParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteSocialMediaHandleParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteSocialMediaHandleParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteSocialMediaHandleParameters
     */
    public function getAttributeName()
    {
        return 'DeleteSocialMediaHandleParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeleteSocialMediaHandleParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
