<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeleteRelationshipResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeleteRelationshipResponse extends AbstractStructArrayBase
{
    /**
     * The DeleteRelationshipResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeleteRelationshipResponse[]
     */
    public $DeleteRelationshipResponse;
    /**
     * Constructor method for ArrayOfDeleteRelationshipResponse
     * @uses ArrayOfDeleteRelationshipResponse::setDeleteRelationshipResponse()
     * @param \StructType\DeleteRelationshipResponse[] $deleteRelationshipResponse
     */
    public function __construct(array $deleteRelationshipResponse = array())
    {
        $this
            ->setDeleteRelationshipResponse($deleteRelationshipResponse);
    }
    /**
     * Get DeleteRelationshipResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeleteRelationshipResponse[]|null
     */
    public function getDeleteRelationshipResponse()
    {
        return isset($this->DeleteRelationshipResponse) ? $this->DeleteRelationshipResponse : null;
    }
    /**
     * Set DeleteRelationshipResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteRelationshipResponse[] $deleteRelationshipResponse
     * @return \ArrayType\ArrayOfDeleteRelationshipResponse
     */
    public function setDeleteRelationshipResponse(array $deleteRelationshipResponse = array())
    {
        foreach ($deleteRelationshipResponse as $arrayOfDeleteRelationshipResponseDeleteRelationshipResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeleteRelationshipResponseDeleteRelationshipResponseItem instanceof \StructType\DeleteRelationshipResponse) {
                throw new \InvalidArgumentException(sprintf('The DeleteRelationshipResponse property can only contain items of \StructType\DeleteRelationshipResponse, "%s" given', is_object($arrayOfDeleteRelationshipResponseDeleteRelationshipResponseItem) ? get_class($arrayOfDeleteRelationshipResponseDeleteRelationshipResponseItem) : gettype($arrayOfDeleteRelationshipResponseDeleteRelationshipResponseItem)), __LINE__);
            }
        }
        if (is_null($deleteRelationshipResponse) || (is_array($deleteRelationshipResponse) && empty($deleteRelationshipResponse))) {
            unset($this->DeleteRelationshipResponse);
        } else {
            $this->DeleteRelationshipResponse = $deleteRelationshipResponse;
        }
        return $this;
    }
    /**
     * Add item to DeleteRelationshipResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteRelationshipResponse $item
     * @return \ArrayType\ArrayOfDeleteRelationshipResponse
     */
    public function addToDeleteRelationshipResponse(\StructType\DeleteRelationshipResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteRelationshipResponse) {
            throw new \InvalidArgumentException(sprintf('The DeleteRelationshipResponse property can only contain items of \StructType\DeleteRelationshipResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeleteRelationshipResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteRelationshipResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteRelationshipResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteRelationshipResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteRelationshipResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteRelationshipResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteRelationshipResponse
     */
    public function getAttributeName()
    {
        return 'DeleteRelationshipResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeleteRelationshipResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
