<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeletePaymentProfileResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeletePaymentProfileResponse extends AbstractStructArrayBase
{
    /**
     * The DeletePaymentProfileResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeletePaymentProfileResponse[]
     */
    public $DeletePaymentProfileResponse;
    /**
     * Constructor method for ArrayOfDeletePaymentProfileResponse
     * @uses ArrayOfDeletePaymentProfileResponse::setDeletePaymentProfileResponse()
     * @param \StructType\DeletePaymentProfileResponse[] $deletePaymentProfileResponse
     */
    public function __construct(array $deletePaymentProfileResponse = array())
    {
        $this
            ->setDeletePaymentProfileResponse($deletePaymentProfileResponse);
    }
    /**
     * Get DeletePaymentProfileResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeletePaymentProfileResponse[]|null
     */
    public function getDeletePaymentProfileResponse()
    {
        return isset($this->DeletePaymentProfileResponse) ? $this->DeletePaymentProfileResponse : null;
    }
    /**
     * Set DeletePaymentProfileResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeletePaymentProfileResponse[] $deletePaymentProfileResponse
     * @return \ArrayType\ArrayOfDeletePaymentProfileResponse
     */
    public function setDeletePaymentProfileResponse(array $deletePaymentProfileResponse = array())
    {
        foreach ($deletePaymentProfileResponse as $arrayOfDeletePaymentProfileResponseDeletePaymentProfileResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeletePaymentProfileResponseDeletePaymentProfileResponseItem instanceof \StructType\DeletePaymentProfileResponse) {
                throw new \InvalidArgumentException(sprintf('The DeletePaymentProfileResponse property can only contain items of \StructType\DeletePaymentProfileResponse, "%s" given', is_object($arrayOfDeletePaymentProfileResponseDeletePaymentProfileResponseItem) ? get_class($arrayOfDeletePaymentProfileResponseDeletePaymentProfileResponseItem) : gettype($arrayOfDeletePaymentProfileResponseDeletePaymentProfileResponseItem)), __LINE__);
            }
        }
        if (is_null($deletePaymentProfileResponse) || (is_array($deletePaymentProfileResponse) && empty($deletePaymentProfileResponse))) {
            unset($this->DeletePaymentProfileResponse);
        } else {
            $this->DeletePaymentProfileResponse = $deletePaymentProfileResponse;
        }
        return $this;
    }
    /**
     * Add item to DeletePaymentProfileResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\DeletePaymentProfileResponse $item
     * @return \ArrayType\ArrayOfDeletePaymentProfileResponse
     */
    public function addToDeletePaymentProfileResponse(\StructType\DeletePaymentProfileResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeletePaymentProfileResponse) {
            throw new \InvalidArgumentException(sprintf('The DeletePaymentProfileResponse property can only contain items of \StructType\DeletePaymentProfileResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeletePaymentProfileResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeletePaymentProfileResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeletePaymentProfileResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeletePaymentProfileResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeletePaymentProfileResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeletePaymentProfileResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeletePaymentProfileResponse
     */
    public function getAttributeName()
    {
        return 'DeletePaymentProfileResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeletePaymentProfileResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
