<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeletePaymentProfileParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeletePaymentProfileParameters extends AbstractStructArrayBase
{
    /**
     * The DeletePaymentProfileParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeletePaymentProfileParameters[]
     */
    public $DeletePaymentProfileParameters;
    /**
     * Constructor method for ArrayOfDeletePaymentProfileParameters
     * @uses ArrayOfDeletePaymentProfileParameters::setDeletePaymentProfileParameters()
     * @param \StructType\DeletePaymentProfileParameters[] $deletePaymentProfileParameters
     */
    public function __construct(array $deletePaymentProfileParameters = array())
    {
        $this
            ->setDeletePaymentProfileParameters($deletePaymentProfileParameters);
    }
    /**
     * Get DeletePaymentProfileParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeletePaymentProfileParameters[]|null
     */
    public function getDeletePaymentProfileParameters()
    {
        return isset($this->DeletePaymentProfileParameters) ? $this->DeletePaymentProfileParameters : null;
    }
    /**
     * Set DeletePaymentProfileParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeletePaymentProfileParameters[] $deletePaymentProfileParameters
     * @return \ArrayType\ArrayOfDeletePaymentProfileParameters
     */
    public function setDeletePaymentProfileParameters(array $deletePaymentProfileParameters = array())
    {
        foreach ($deletePaymentProfileParameters as $arrayOfDeletePaymentProfileParametersDeletePaymentProfileParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeletePaymentProfileParametersDeletePaymentProfileParametersItem instanceof \StructType\DeletePaymentProfileParameters) {
                throw new \InvalidArgumentException(sprintf('The DeletePaymentProfileParameters property can only contain items of \StructType\DeletePaymentProfileParameters, "%s" given', is_object($arrayOfDeletePaymentProfileParametersDeletePaymentProfileParametersItem) ? get_class($arrayOfDeletePaymentProfileParametersDeletePaymentProfileParametersItem) : gettype($arrayOfDeletePaymentProfileParametersDeletePaymentProfileParametersItem)), __LINE__);
            }
        }
        if (is_null($deletePaymentProfileParameters) || (is_array($deletePaymentProfileParameters) && empty($deletePaymentProfileParameters))) {
            unset($this->DeletePaymentProfileParameters);
        } else {
            $this->DeletePaymentProfileParameters = $deletePaymentProfileParameters;
        }
        return $this;
    }
    /**
     * Add item to DeletePaymentProfileParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\DeletePaymentProfileParameters $item
     * @return \ArrayType\ArrayOfDeletePaymentProfileParameters
     */
    public function addToDeletePaymentProfileParameters(\StructType\DeletePaymentProfileParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeletePaymentProfileParameters) {
            throw new \InvalidArgumentException(sprintf('The DeletePaymentProfileParameters property can only contain items of \StructType\DeletePaymentProfileParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeletePaymentProfileParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeletePaymentProfileParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeletePaymentProfileParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeletePaymentProfileParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeletePaymentProfileParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeletePaymentProfileParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeletePaymentProfileParameters
     */
    public function getAttributeName()
    {
        return 'DeletePaymentProfileParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeletePaymentProfileParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
