<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeleteNoteResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeleteNoteResponse extends AbstractStructArrayBase
{
    /**
     * The DeleteNoteResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeleteNoteResponse[]
     */
    public $DeleteNoteResponse;
    /**
     * Constructor method for ArrayOfDeleteNoteResponse
     * @uses ArrayOfDeleteNoteResponse::setDeleteNoteResponse()
     * @param \StructType\DeleteNoteResponse[] $deleteNoteResponse
     */
    public function __construct(array $deleteNoteResponse = array())
    {
        $this
            ->setDeleteNoteResponse($deleteNoteResponse);
    }
    /**
     * Get DeleteNoteResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeleteNoteResponse[]|null
     */
    public function getDeleteNoteResponse()
    {
        return isset($this->DeleteNoteResponse) ? $this->DeleteNoteResponse : null;
    }
    /**
     * Set DeleteNoteResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteNoteResponse[] $deleteNoteResponse
     * @return \ArrayType\ArrayOfDeleteNoteResponse
     */
    public function setDeleteNoteResponse(array $deleteNoteResponse = array())
    {
        foreach ($deleteNoteResponse as $arrayOfDeleteNoteResponseDeleteNoteResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeleteNoteResponseDeleteNoteResponseItem instanceof \StructType\DeleteNoteResponse) {
                throw new \InvalidArgumentException(sprintf('The DeleteNoteResponse property can only contain items of \StructType\DeleteNoteResponse, "%s" given', is_object($arrayOfDeleteNoteResponseDeleteNoteResponseItem) ? get_class($arrayOfDeleteNoteResponseDeleteNoteResponseItem) : gettype($arrayOfDeleteNoteResponseDeleteNoteResponseItem)), __LINE__);
            }
        }
        if (is_null($deleteNoteResponse) || (is_array($deleteNoteResponse) && empty($deleteNoteResponse))) {
            unset($this->DeleteNoteResponse);
        } else {
            $this->DeleteNoteResponse = $deleteNoteResponse;
        }
        return $this;
    }
    /**
     * Add item to DeleteNoteResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteNoteResponse $item
     * @return \ArrayType\ArrayOfDeleteNoteResponse
     */
    public function addToDeleteNoteResponse(\StructType\DeleteNoteResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteNoteResponse) {
            throw new \InvalidArgumentException(sprintf('The DeleteNoteResponse property can only contain items of \StructType\DeleteNoteResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeleteNoteResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteNoteResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteNoteResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteNoteResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteNoteResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteNoteResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteNoteResponse
     */
    public function getAttributeName()
    {
        return 'DeleteNoteResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeleteNoteResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
