<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContactSummary ArrayType
 * @subpackage Arrays
 */
class ArrayOfContactSummary extends AbstractStructArrayBase
{
    /**
     * The ContactSummary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactSummary[]
     */
    public $ContactSummary;
    /**
     * Constructor method for ArrayOfContactSummary
     * @uses ArrayOfContactSummary::setContactSummary()
     * @param \StructType\ContactSummary[] $contactSummary
     */
    public function __construct(array $contactSummary = array())
    {
        $this
            ->setContactSummary($contactSummary);
    }
    /**
     * Get ContactSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactSummary[]|null
     */
    public function getContactSummary()
    {
        return isset($this->ContactSummary) ? $this->ContactSummary : null;
    }
    /**
     * Set ContactSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContactSummary[] $contactSummary
     * @return \ArrayType\ArrayOfContactSummary
     */
    public function setContactSummary(array $contactSummary = array())
    {
        foreach ($contactSummary as $arrayOfContactSummaryContactSummaryItem) {
            // validation for constraint: itemType
            if (!$arrayOfContactSummaryContactSummaryItem instanceof \StructType\ContactSummary) {
                throw new \InvalidArgumentException(sprintf('The ContactSummary property can only contain items of \StructType\ContactSummary, "%s" given', is_object($arrayOfContactSummaryContactSummaryItem) ? get_class($arrayOfContactSummaryContactSummaryItem) : gettype($arrayOfContactSummaryContactSummaryItem)), __LINE__);
            }
        }
        if (is_null($contactSummary) || (is_array($contactSummary) && empty($contactSummary))) {
            unset($this->ContactSummary);
        } else {
            $this->ContactSummary = $contactSummary;
        }
        return $this;
    }
    /**
     * Add item to ContactSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactSummary $item
     * @return \ArrayType\ArrayOfContactSummary
     */
    public function addToContactSummary(\StructType\ContactSummary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactSummary) {
            throw new \InvalidArgumentException(sprintf('The ContactSummary property can only contain items of \StructType\ContactSummary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactSummary[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ContactSummary|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ContactSummary|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ContactSummary|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ContactSummary|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ContactSummary|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContactSummary
     */
    public function getAttributeName()
    {
        return 'ContactSummary';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfContactSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
