<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContactOptInList ArrayType
 * @subpackage Arrays
 */
class ArrayOfContactOptInList extends AbstractStructArrayBase
{
    /**
     * The ContactOptInList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactOptInList[]
     */
    public $ContactOptInList;
    /**
     * Constructor method for ArrayOfContactOptInList
     * @uses ArrayOfContactOptInList::setContactOptInList()
     * @param \StructType\ContactOptInList[] $contactOptInList
     */
    public function __construct(array $contactOptInList = array())
    {
        $this
            ->setContactOptInList($contactOptInList);
    }
    /**
     * Get ContactOptInList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactOptInList[]|null
     */
    public function getContactOptInList()
    {
        return isset($this->ContactOptInList) ? $this->ContactOptInList : null;
    }
    /**
     * Set ContactOptInList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContactOptInList[] $contactOptInList
     * @return \ArrayType\ArrayOfContactOptInList
     */
    public function setContactOptInList(array $contactOptInList = array())
    {
        foreach ($contactOptInList as $arrayOfContactOptInListContactOptInListItem) {
            // validation for constraint: itemType
            if (!$arrayOfContactOptInListContactOptInListItem instanceof \StructType\ContactOptInList) {
                throw new \InvalidArgumentException(sprintf('The ContactOptInList property can only contain items of \StructType\ContactOptInList, "%s" given', is_object($arrayOfContactOptInListContactOptInListItem) ? get_class($arrayOfContactOptInListContactOptInListItem) : gettype($arrayOfContactOptInListContactOptInListItem)), __LINE__);
            }
        }
        if (is_null($contactOptInList) || (is_array($contactOptInList) && empty($contactOptInList))) {
            unset($this->ContactOptInList);
        } else {
            $this->ContactOptInList = $contactOptInList;
        }
        return $this;
    }
    /**
     * Add item to ContactOptInList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactOptInList $item
     * @return \ArrayType\ArrayOfContactOptInList
     */
    public function addToContactOptInList(\StructType\ContactOptInList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactOptInList) {
            throw new \InvalidArgumentException(sprintf('The ContactOptInList property can only contain items of \StructType\ContactOptInList, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactOptInList[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ContactOptInList|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ContactOptInList|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ContactOptInList|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ContactOptInList|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ContactOptInList|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContactOptInList
     */
    public function getAttributeName()
    {
        return 'ContactOptInList';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfContactOptInList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
