<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfChargeContactPaymentProfileParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfChargeContactPaymentProfileParameters extends AbstractStructArrayBase
{
    /**
     * The ChargeContactPaymentProfileParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ChargeContactPaymentProfileParameters[]
     */
    public $ChargeContactPaymentProfileParameters;
    /**
     * Constructor method for ArrayOfChargeContactPaymentProfileParameters
     * @uses ArrayOfChargeContactPaymentProfileParameters::setChargeContactPaymentProfileParameters()
     * @param \StructType\ChargeContactPaymentProfileParameters[] $chargeContactPaymentProfileParameters
     */
    public function __construct(array $chargeContactPaymentProfileParameters = array())
    {
        $this
            ->setChargeContactPaymentProfileParameters($chargeContactPaymentProfileParameters);
    }
    /**
     * Get ChargeContactPaymentProfileParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ChargeContactPaymentProfileParameters[]|null
     */
    public function getChargeContactPaymentProfileParameters()
    {
        return isset($this->ChargeContactPaymentProfileParameters) ? $this->ChargeContactPaymentProfileParameters : null;
    }
    /**
     * Set ChargeContactPaymentProfileParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ChargeContactPaymentProfileParameters[] $chargeContactPaymentProfileParameters
     * @return \ArrayType\ArrayOfChargeContactPaymentProfileParameters
     */
    public function setChargeContactPaymentProfileParameters(array $chargeContactPaymentProfileParameters = array())
    {
        foreach ($chargeContactPaymentProfileParameters as $arrayOfChargeContactPaymentProfileParametersChargeContactPaymentProfileParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfChargeContactPaymentProfileParametersChargeContactPaymentProfileParametersItem instanceof \StructType\ChargeContactPaymentProfileParameters) {
                throw new \InvalidArgumentException(sprintf('The ChargeContactPaymentProfileParameters property can only contain items of \StructType\ChargeContactPaymentProfileParameters, "%s" given', is_object($arrayOfChargeContactPaymentProfileParametersChargeContactPaymentProfileParametersItem) ? get_class($arrayOfChargeContactPaymentProfileParametersChargeContactPaymentProfileParametersItem) : gettype($arrayOfChargeContactPaymentProfileParametersChargeContactPaymentProfileParametersItem)), __LINE__);
            }
        }
        if (is_null($chargeContactPaymentProfileParameters) || (is_array($chargeContactPaymentProfileParameters) && empty($chargeContactPaymentProfileParameters))) {
            unset($this->ChargeContactPaymentProfileParameters);
        } else {
            $this->ChargeContactPaymentProfileParameters = $chargeContactPaymentProfileParameters;
        }
        return $this;
    }
    /**
     * Add item to ChargeContactPaymentProfileParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\ChargeContactPaymentProfileParameters $item
     * @return \ArrayType\ArrayOfChargeContactPaymentProfileParameters
     */
    public function addToChargeContactPaymentProfileParameters(\StructType\ChargeContactPaymentProfileParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChargeContactPaymentProfileParameters) {
            throw new \InvalidArgumentException(sprintf('The ChargeContactPaymentProfileParameters property can only contain items of \StructType\ChargeContactPaymentProfileParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ChargeContactPaymentProfileParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ChargeContactPaymentProfileParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ChargeContactPaymentProfileParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ChargeContactPaymentProfileParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ChargeContactPaymentProfileParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ChargeContactPaymentProfileParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ChargeContactPaymentProfileParameters
     */
    public function getAttributeName()
    {
        return 'ChargeContactPaymentProfileParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfChargeContactPaymentProfileParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
