<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebServiceQueryBase StructType
 * @subpackage Structs
 */
class WebServiceQueryBase extends AbstractStructBase
{
    /**
     * The OrderByDirection
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $OrderByDirection;
    /**
     * The QueryType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $QueryType;
    /**
     * The OrderByField
     * @var string
     */
    public $OrderByField;
    /**
     * Constructor method for WebServiceQueryBase
     * @uses WebServiceQueryBase::setOrderByDirection()
     * @uses WebServiceQueryBase::setQueryType()
     * @uses WebServiceQueryBase::setOrderByField()
     * @param string $orderByDirection
     * @param string $queryType
     * @param string $orderByField
     */
    public function __construct($orderByDirection = null, $queryType = null, $orderByField = null)
    {
        $this
            ->setOrderByDirection($orderByDirection)
            ->setQueryType($queryType)
            ->setOrderByField($orderByField);
    }
    /**
     * Get OrderByDirection value
     * @return string
     */
    public function getOrderByDirection()
    {
        return $this->OrderByDirection;
    }
    /**
     * Set OrderByDirection value
     * @uses \EnumType\OrderByDirections::valueIsValid()
     * @uses \EnumType\OrderByDirections::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderByDirection
     * @return \StructType\WebServiceQueryBase
     */
    public function setOrderByDirection($orderByDirection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderByDirections::valueIsValid($orderByDirection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $orderByDirection, implode(', ', \EnumType\OrderByDirections::getValidValues())), __LINE__);
        }
        $this->OrderByDirection = $orderByDirection;
        return $this;
    }
    /**
     * Get QueryType value
     * @return string
     */
    public function getQueryType()
    {
        return $this->QueryType;
    }
    /**
     * Set QueryType value
     * @uses \EnumType\QueryTypes::valueIsValid()
     * @uses \EnumType\QueryTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $queryType
     * @return \StructType\WebServiceQueryBase
     */
    public function setQueryType($queryType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QueryTypes::valueIsValid($queryType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $queryType, implode(', ', \EnumType\QueryTypes::getValidValues())), __LINE__);
        }
        $this->QueryType = $queryType;
        return $this;
    }
    /**
     * Get OrderByField value
     * @return string|null
     */
    public function getOrderByField()
    {
        return $this->OrderByField;
    }
    /**
     * Set OrderByField value
     * @param string $orderByField
     * @return \StructType\WebServiceQueryBase
     */
    public function setOrderByField($orderByField = null)
    {
        // validation for constraint: string
        if (!is_null($orderByField) && !is_string($orderByField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderByField)), __LINE__);
        }
        $this->OrderByField = $orderByField;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebServiceQueryBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
