<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TributeRecord StructType
 * @subpackage Structs
 */
class TributeRecord extends DataRecord
{
    /**
     * The Goal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Goal;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Active;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $Contact;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for TributeRecord
     * @uses TributeRecord::setGoal()
     * @uses TributeRecord::setStartDate()
     * @uses TributeRecord::setEndDate()
     * @uses TributeRecord::setType()
     * @uses TributeRecord::setActive()
     * @uses TributeRecord::setContact()
     * @uses TributeRecord::setName()
     * @param float $goal
     * @param string $startDate
     * @param string $endDate
     * @param string $type
     * @param bool $active
     * @param \StructType\ContactSummary $contact
     * @param string $name
     */
    public function __construct($goal = null, $startDate = null, $endDate = null, $type = null, $active = null, \StructType\ContactSummary $contact = null, $name = null)
    {
        $this
            ->setGoal($goal)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setType($type)
            ->setActive($active)
            ->setContact($contact)
            ->setName($name);
    }
    /**
     * Get Goal value
     * @return float
     */
    public function getGoal()
    {
        return $this->Goal;
    }
    /**
     * Set Goal value
     * @param float $goal
     * @return \StructType\TributeRecord
     */
    public function setGoal($goal = null)
    {
        $this->Goal = $goal;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\TributeRecord
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\TributeRecord
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\TributeTypes::valueIsValid()
     * @uses \EnumType\TributeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\TributeRecord
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TributeTypes::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\TributeTypes::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\TributeRecord
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\ContactSummary|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\ContactSummary $contact
     * @return \StructType\TributeRecord
     */
    public function setContact(\StructType\ContactSummary $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\TributeRecord
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TributeRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
