<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TributeAcknowledgeeRecord StructType
 * @subpackage Structs
 */
class TributeAcknowledgeeRecord extends DataRecord
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Active;
    /**
     * The Tribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TributeRecord
     */
    public $Tribute;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for TributeAcknowledgeeRecord
     * @uses TributeAcknowledgeeRecord::setActive()
     * @uses TributeAcknowledgeeRecord::setTribute()
     * @uses TributeAcknowledgeeRecord::setMessage()
     * @param bool $active
     * @param \StructType\TributeRecord $tribute
     * @param string $message
     */
    public function __construct($active = null, \StructType\TributeRecord $tribute = null, $message = null)
    {
        $this
            ->setActive($active)
            ->setTribute($tribute)
            ->setMessage($message);
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\TributeAcknowledgeeRecord
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Tribute value
     * @return \StructType\TributeRecord|null
     */
    public function getTribute()
    {
        return $this->Tribute;
    }
    /**
     * Set Tribute value
     * @param \StructType\TributeRecord $tribute
     * @return \StructType\TributeAcknowledgeeRecord
     */
    public function setTribute(\StructType\TributeRecord $tribute = null)
    {
        $this->Tribute = $tribute;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\TributeAcknowledgeeRecord
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TributeAcknowledgeeRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
