<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SustainerRecord StructType
 * @subpackage Structs
 */
class SustainerRecord extends DataRecord
{
    /**
     * The CancelUser_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CancelUser_Id;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The NextPaymentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NextPaymentDate;
    /**
     * The AmountPaid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmountPaid;
    /**
     * The CreditCardType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreditCardType;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Active;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The Frequency
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Frequency;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $Contact;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SustainerType
     */
    public $Type;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TransactionCategory
     */
    public $Category;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SustainerStatus
     */
    public $Status;
    /**
     * The ContactInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerDetail
     */
    public $ContactInfo;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentMethod
     */
    public $PaymentMethod;
    /**
     * The BillingDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BillingInfoCollection
     */
    public $BillingDetail;
    /**
     * The Attribution
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AttributionInfoCollection
     */
    public $Attribution;
    /**
     * The CreditCardNumberLastFour
     * @var string
     */
    public $CreditCardNumberLastFour;
    /**
     * The AchAccountNumberLastFour
     * @var string
     */
    public $AchAccountNumberLastFour;
    /**
     * Constructor method for SustainerRecord
     * @uses SustainerRecord::setCancelUser_Id()
     * @uses SustainerRecord::setStartDate()
     * @uses SustainerRecord::setEndDate()
     * @uses SustainerRecord::setNextPaymentDate()
     * @uses SustainerRecord::setAmountPaid()
     * @uses SustainerRecord::setCreditCardType()
     * @uses SustainerRecord::setActive()
     * @uses SustainerRecord::setAmount()
     * @uses SustainerRecord::setFrequency()
     * @uses SustainerRecord::setContact()
     * @uses SustainerRecord::setType()
     * @uses SustainerRecord::setCategory()
     * @uses SustainerRecord::setStatus()
     * @uses SustainerRecord::setContactInfo()
     * @uses SustainerRecord::setPaymentMethod()
     * @uses SustainerRecord::setBillingDetail()
     * @uses SustainerRecord::setAttribution()
     * @uses SustainerRecord::setCreditCardNumberLastFour()
     * @uses SustainerRecord::setAchAccountNumberLastFour()
     * @param int $cancelUser_Id
     * @param string $startDate
     * @param string $endDate
     * @param string $nextPaymentDate
     * @param float $amountPaid
     * @param string $creditCardType
     * @param bool $active
     * @param float $amount
     * @param string $frequency
     * @param \StructType\ContactSummary $contact
     * @param \StructType\SustainerType $type
     * @param \StructType\TransactionCategory $category
     * @param \StructType\SustainerStatus $status
     * @param \StructType\CustomerDetail $contactInfo
     * @param \StructType\PaymentMethod $paymentMethod
     * @param \StructType\BillingInfoCollection $billingDetail
     * @param \StructType\AttributionInfoCollection $attribution
     * @param string $creditCardNumberLastFour
     * @param string $achAccountNumberLastFour
     */
    public function __construct($cancelUser_Id = null, $startDate = null, $endDate = null, $nextPaymentDate = null, $amountPaid = null, $creditCardType = null, $active = null, $amount = null, $frequency = null, \StructType\ContactSummary $contact = null, \StructType\SustainerType $type = null, \StructType\TransactionCategory $category = null, \StructType\SustainerStatus $status = null, \StructType\CustomerDetail $contactInfo = null, \StructType\PaymentMethod $paymentMethod = null, \StructType\BillingInfoCollection $billingDetail = null, \StructType\AttributionInfoCollection $attribution = null, $creditCardNumberLastFour = null, $achAccountNumberLastFour = null)
    {
        $this
            ->setCancelUser_Id($cancelUser_Id)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setNextPaymentDate($nextPaymentDate)
            ->setAmountPaid($amountPaid)
            ->setCreditCardType($creditCardType)
            ->setActive($active)
            ->setAmount($amount)
            ->setFrequency($frequency)
            ->setContact($contact)
            ->setType($type)
            ->setCategory($category)
            ->setStatus($status)
            ->setContactInfo($contactInfo)
            ->setPaymentMethod($paymentMethod)
            ->setBillingDetail($billingDetail)
            ->setAttribution($attribution)
            ->setCreditCardNumberLastFour($creditCardNumberLastFour)
            ->setAchAccountNumberLastFour($achAccountNumberLastFour);
    }
    /**
     * Get CancelUser_Id value
     * @return int
     */
    public function getCancelUser_Id()
    {
        return $this->CancelUser_Id;
    }
    /**
     * Set CancelUser_Id value
     * @param int $cancelUser_Id
     * @return \StructType\SustainerRecord
     */
    public function setCancelUser_Id($cancelUser_Id = null)
    {
        // validation for constraint: int
        if (!is_null($cancelUser_Id) && !is_numeric($cancelUser_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cancelUser_Id)), __LINE__);
        }
        $this->CancelUser_Id = $cancelUser_Id;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\SustainerRecord
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\SustainerRecord
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get NextPaymentDate value
     * @return string
     */
    public function getNextPaymentDate()
    {
        return $this->NextPaymentDate;
    }
    /**
     * Set NextPaymentDate value
     * @param string $nextPaymentDate
     * @return \StructType\SustainerRecord
     */
    public function setNextPaymentDate($nextPaymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextPaymentDate) && !is_string($nextPaymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextPaymentDate)), __LINE__);
        }
        $this->NextPaymentDate = $nextPaymentDate;
        return $this;
    }
    /**
     * Get AmountPaid value
     * @return float
     */
    public function getAmountPaid()
    {
        return $this->AmountPaid;
    }
    /**
     * Set AmountPaid value
     * @param float $amountPaid
     * @return \StructType\SustainerRecord
     */
    public function setAmountPaid($amountPaid = null)
    {
        $this->AmountPaid = $amountPaid;
        return $this;
    }
    /**
     * Get CreditCardType value
     * @return string
     */
    public function getCreditCardType()
    {
        return $this->CreditCardType;
    }
    /**
     * Set CreditCardType value
     * @uses \EnumType\CreditCardTypes::valueIsValid()
     * @uses \EnumType\CreditCardTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $creditCardType
     * @return \StructType\SustainerRecord
     */
    public function setCreditCardType($creditCardType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CreditCardTypes::valueIsValid($creditCardType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $creditCardType, implode(', ', \EnumType\CreditCardTypes::getValidValues())), __LINE__);
        }
        $this->CreditCardType = $creditCardType;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\SustainerRecord
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\SustainerRecord
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Frequency value
     * @return string
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @uses \EnumType\SustainerFrequencies::valueIsValid()
     * @uses \EnumType\SustainerFrequencies::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $frequency
     * @return \StructType\SustainerRecord
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SustainerFrequencies::valueIsValid($frequency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $frequency, implode(', ', \EnumType\SustainerFrequencies::getValidValues())), __LINE__);
        }
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\ContactSummary|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\ContactSummary $contact
     * @return \StructType\SustainerRecord
     */
    public function setContact(\StructType\ContactSummary $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\SustainerType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\SustainerType $type
     * @return \StructType\SustainerRecord
     */
    public function setType(\StructType\SustainerType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Category value
     * @return \StructType\TransactionCategory|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param \StructType\TransactionCategory $category
     * @return \StructType\SustainerRecord
     */
    public function setCategory(\StructType\TransactionCategory $category = null)
    {
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\SustainerStatus|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\SustainerStatus $status
     * @return \StructType\SustainerRecord
     */
    public function setStatus(\StructType\SustainerStatus $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\CustomerDetail|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\CustomerDetail $contactInfo
     * @return \StructType\SustainerRecord
     */
    public function setContactInfo(\StructType\CustomerDetail $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return \StructType\PaymentMethod|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param \StructType\PaymentMethod $paymentMethod
     * @return \StructType\SustainerRecord
     */
    public function setPaymentMethod(\StructType\PaymentMethod $paymentMethod = null)
    {
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get BillingDetail value
     * @return \StructType\BillingInfoCollection|null
     */
    public function getBillingDetail()
    {
        return $this->BillingDetail;
    }
    /**
     * Set BillingDetail value
     * @param \StructType\BillingInfoCollection $billingDetail
     * @return \StructType\SustainerRecord
     */
    public function setBillingDetail(\StructType\BillingInfoCollection $billingDetail = null)
    {
        $this->BillingDetail = $billingDetail;
        return $this;
    }
    /**
     * Get Attribution value
     * @return \StructType\AttributionInfoCollection|null
     */
    public function getAttribution()
    {
        return $this->Attribution;
    }
    /**
     * Set Attribution value
     * @param \StructType\AttributionInfoCollection $attribution
     * @return \StructType\SustainerRecord
     */
    public function setAttribution(\StructType\AttributionInfoCollection $attribution = null)
    {
        $this->Attribution = $attribution;
        return $this;
    }
    /**
     * Get CreditCardNumberLastFour value
     * @return string|null
     */
    public function getCreditCardNumberLastFour()
    {
        return $this->CreditCardNumberLastFour;
    }
    /**
     * Set CreditCardNumberLastFour value
     * @param string $creditCardNumberLastFour
     * @return \StructType\SustainerRecord
     */
    public function setCreditCardNumberLastFour($creditCardNumberLastFour = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardNumberLastFour) && !is_string($creditCardNumberLastFour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardNumberLastFour)), __LINE__);
        }
        $this->CreditCardNumberLastFour = $creditCardNumberLastFour;
        return $this;
    }
    /**
     * Get AchAccountNumberLastFour value
     * @return string|null
     */
    public function getAchAccountNumberLastFour()
    {
        return $this->AchAccountNumberLastFour;
    }
    /**
     * Set AchAccountNumberLastFour value
     * @param string $achAccountNumberLastFour
     * @return \StructType\SustainerRecord
     */
    public function setAchAccountNumberLastFour($achAccountNumberLastFour = null)
    {
        // validation for constraint: string
        if (!is_null($achAccountNumberLastFour) && !is_string($achAccountNumberLastFour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($achAccountNumberLastFour)), __LINE__);
        }
        $this->AchAccountNumberLastFour = $achAccountNumberLastFour;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SustainerRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
