<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationshipRecord StructType
 * @subpackage Structs
 */
class RelationshipRecord extends DataRecord
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The PrimaryContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $PrimaryContact;
    /**
     * The PrimaryContactRelationshipType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RelationshipType
     */
    public $PrimaryContactRelationshipType;
    /**
     * The RelatedContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $RelatedContact;
    /**
     * The RelatedContactRelationshipType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RelationshipType
     */
    public $RelatedContactRelationshipType;
    /**
     * Constructor method for RelationshipRecord
     * @uses RelationshipRecord::setStartDate()
     * @uses RelationshipRecord::setEndDate()
     * @uses RelationshipRecord::setPrimaryContact()
     * @uses RelationshipRecord::setPrimaryContactRelationshipType()
     * @uses RelationshipRecord::setRelatedContact()
     * @uses RelationshipRecord::setRelatedContactRelationshipType()
     * @param string $startDate
     * @param string $endDate
     * @param \StructType\ContactSummary $primaryContact
     * @param \StructType\RelationshipType $primaryContactRelationshipType
     * @param \StructType\ContactSummary $relatedContact
     * @param \StructType\RelationshipType $relatedContactRelationshipType
     */
    public function __construct($startDate = null, $endDate = null, \StructType\ContactSummary $primaryContact = null, \StructType\RelationshipType $primaryContactRelationshipType = null, \StructType\ContactSummary $relatedContact = null, \StructType\RelationshipType $relatedContactRelationshipType = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setPrimaryContact($primaryContact)
            ->setPrimaryContactRelationshipType($primaryContactRelationshipType)
            ->setRelatedContact($relatedContact)
            ->setRelatedContactRelationshipType($relatedContactRelationshipType);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\RelationshipRecord
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\RelationshipRecord
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get PrimaryContact value
     * @return \StructType\ContactSummary|null
     */
    public function getPrimaryContact()
    {
        return $this->PrimaryContact;
    }
    /**
     * Set PrimaryContact value
     * @param \StructType\ContactSummary $primaryContact
     * @return \StructType\RelationshipRecord
     */
    public function setPrimaryContact(\StructType\ContactSummary $primaryContact = null)
    {
        $this->PrimaryContact = $primaryContact;
        return $this;
    }
    /**
     * Get PrimaryContactRelationshipType value
     * @return \StructType\RelationshipType|null
     */
    public function getPrimaryContactRelationshipType()
    {
        return $this->PrimaryContactRelationshipType;
    }
    /**
     * Set PrimaryContactRelationshipType value
     * @param \StructType\RelationshipType $primaryContactRelationshipType
     * @return \StructType\RelationshipRecord
     */
    public function setPrimaryContactRelationshipType(\StructType\RelationshipType $primaryContactRelationshipType = null)
    {
        $this->PrimaryContactRelationshipType = $primaryContactRelationshipType;
        return $this;
    }
    /**
     * Get RelatedContact value
     * @return \StructType\ContactSummary|null
     */
    public function getRelatedContact()
    {
        return $this->RelatedContact;
    }
    /**
     * Set RelatedContact value
     * @param \StructType\ContactSummary $relatedContact
     * @return \StructType\RelationshipRecord
     */
    public function setRelatedContact(\StructType\ContactSummary $relatedContact = null)
    {
        $this->RelatedContact = $relatedContact;
        return $this;
    }
    /**
     * Get RelatedContactRelationshipType value
     * @return \StructType\RelationshipType|null
     */
    public function getRelatedContactRelationshipType()
    {
        return $this->RelatedContactRelationshipType;
    }
    /**
     * Set RelatedContactRelationshipType value
     * @param \StructType\RelationshipType $relatedContactRelationshipType
     * @return \StructType\RelationshipRecord
     */
    public function setRelatedContactRelationshipType(\StructType\RelationshipType $relatedContactRelationshipType = null)
    {
        $this->RelatedContactRelationshipType = $relatedContactRelationshipType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RelationshipRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
