<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PeerToPeerPageRecord StructType
 * @subpackage Structs
 */
class PeerToPeerPageRecord extends DataRecord
{
    /**
     * The Goal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Goal;
    /**
     * The AmountRaised
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmountRaised;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Active;
    /**
     * The Microsite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PeerToPeerMicrositeDetail
     */
    public $Microsite;
    /**
     * The Team
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PeerToPeerTeamDetail
     */
    public $Team;
    /**
     * The Fundraiser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $Fundraiser;
    /**
     * The PageName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PageName;
    /**
     * Constructor method for PeerToPeerPageRecord
     * @uses PeerToPeerPageRecord::setGoal()
     * @uses PeerToPeerPageRecord::setAmountRaised()
     * @uses PeerToPeerPageRecord::setActive()
     * @uses PeerToPeerPageRecord::setMicrosite()
     * @uses PeerToPeerPageRecord::setTeam()
     * @uses PeerToPeerPageRecord::setFundraiser()
     * @uses PeerToPeerPageRecord::setPageName()
     * @param float $goal
     * @param float $amountRaised
     * @param bool $active
     * @param \StructType\PeerToPeerMicrositeDetail $microsite
     * @param \StructType\PeerToPeerTeamDetail $team
     * @param \StructType\ContactSummary $fundraiser
     * @param string $pageName
     */
    public function __construct($goal = null, $amountRaised = null, $active = null, \StructType\PeerToPeerMicrositeDetail $microsite = null, \StructType\PeerToPeerTeamDetail $team = null, \StructType\ContactSummary $fundraiser = null, $pageName = null)
    {
        $this
            ->setGoal($goal)
            ->setAmountRaised($amountRaised)
            ->setActive($active)
            ->setMicrosite($microsite)
            ->setTeam($team)
            ->setFundraiser($fundraiser)
            ->setPageName($pageName);
    }
    /**
     * Get Goal value
     * @return float
     */
    public function getGoal()
    {
        return $this->Goal;
    }
    /**
     * Set Goal value
     * @param float $goal
     * @return \StructType\PeerToPeerPageRecord
     */
    public function setGoal($goal = null)
    {
        $this->Goal = $goal;
        return $this;
    }
    /**
     * Get AmountRaised value
     * @return float
     */
    public function getAmountRaised()
    {
        return $this->AmountRaised;
    }
    /**
     * Set AmountRaised value
     * @param float $amountRaised
     * @return \StructType\PeerToPeerPageRecord
     */
    public function setAmountRaised($amountRaised = null)
    {
        $this->AmountRaised = $amountRaised;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\PeerToPeerPageRecord
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Microsite value
     * @return \StructType\PeerToPeerMicrositeDetail|null
     */
    public function getMicrosite()
    {
        return $this->Microsite;
    }
    /**
     * Set Microsite value
     * @param \StructType\PeerToPeerMicrositeDetail $microsite
     * @return \StructType\PeerToPeerPageRecord
     */
    public function setMicrosite(\StructType\PeerToPeerMicrositeDetail $microsite = null)
    {
        $this->Microsite = $microsite;
        return $this;
    }
    /**
     * Get Team value
     * @return \StructType\PeerToPeerTeamDetail|null
     */
    public function getTeam()
    {
        return $this->Team;
    }
    /**
     * Set Team value
     * @param \StructType\PeerToPeerTeamDetail $team
     * @return \StructType\PeerToPeerPageRecord
     */
    public function setTeam(\StructType\PeerToPeerTeamDetail $team = null)
    {
        $this->Team = $team;
        return $this;
    }
    /**
     * Get Fundraiser value
     * @return \StructType\ContactSummary|null
     */
    public function getFundraiser()
    {
        return $this->Fundraiser;
    }
    /**
     * Set Fundraiser value
     * @param \StructType\ContactSummary $fundraiser
     * @return \StructType\PeerToPeerPageRecord
     */
    public function setFundraiser(\StructType\ContactSummary $fundraiser = null)
    {
        $this->Fundraiser = $fundraiser;
        return $this;
    }
    /**
     * Get PageName value
     * @return string|null
     */
    public function getPageName()
    {
        return $this->PageName;
    }
    /**
     * Set PageName value
     * @param string $pageName
     * @return \StructType\PeerToPeerPageRecord
     */
    public function setPageName($pageName = null)
    {
        // validation for constraint: string
        if (!is_null($pageName) && !is_string($pageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pageName)), __LINE__);
        }
        $this->PageName = $pageName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PeerToPeerPageRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
