<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrganizationDetail StructType
 * @subpackage Structs
 */
class OrganizationDetail extends DependentMetaData
{
    /**
     * The Parent_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Parent_Id;
    /**
     * The MatchesGifts
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $MatchesGifts;
    /**
     * The GiftMatchingRatio
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $GiftMatchingRatio;
    /**
     * The GiftMatchingRangeMinimum
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $GiftMatchingRangeMinimum;
    /**
     * The GiftMatchingRangeMaximum
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $GiftMatchingRangeMaximum;
    /**
     * The GiftMatchingMaximumGift
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $GiftMatchingMaximumGift;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrganizationType
     */
    public $Type;
    /**
     * The Industry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IndustryDetail
     */
    public $Industry;
    /**
     * Constructor method for OrganizationDetail
     * @uses OrganizationDetail::setParent_Id()
     * @uses OrganizationDetail::setMatchesGifts()
     * @uses OrganizationDetail::setGiftMatchingRatio()
     * @uses OrganizationDetail::setGiftMatchingRangeMinimum()
     * @uses OrganizationDetail::setGiftMatchingRangeMaximum()
     * @uses OrganizationDetail::setGiftMatchingMaximumGift()
     * @uses OrganizationDetail::setName()
     * @uses OrganizationDetail::setType()
     * @uses OrganizationDetail::setIndustry()
     * @param int $parent_Id
     * @param bool $matchesGifts
     * @param float $giftMatchingRatio
     * @param float $giftMatchingRangeMinimum
     * @param float $giftMatchingRangeMaximum
     * @param float $giftMatchingMaximumGift
     * @param string $name
     * @param \StructType\OrganizationType $type
     * @param \StructType\IndustryDetail $industry
     */
    public function __construct($parent_Id = null, $matchesGifts = null, $giftMatchingRatio = null, $giftMatchingRangeMinimum = null, $giftMatchingRangeMaximum = null, $giftMatchingMaximumGift = null, $name = null, \StructType\OrganizationType $type = null, \StructType\IndustryDetail $industry = null)
    {
        $this
            ->setParent_Id($parent_Id)
            ->setMatchesGifts($matchesGifts)
            ->setGiftMatchingRatio($giftMatchingRatio)
            ->setGiftMatchingRangeMinimum($giftMatchingRangeMinimum)
            ->setGiftMatchingRangeMaximum($giftMatchingRangeMaximum)
            ->setGiftMatchingMaximumGift($giftMatchingMaximumGift)
            ->setName($name)
            ->setType($type)
            ->setIndustry($industry);
    }
    /**
     * Get Parent_Id value
     * @return int
     */
    public function getParent_Id()
    {
        return $this->Parent_Id;
    }
    /**
     * Set Parent_Id value
     * @param int $parent_Id
     * @return \StructType\OrganizationDetail
     */
    public function setParent_Id($parent_Id = null)
    {
        // validation for constraint: int
        if (!is_null($parent_Id) && !is_numeric($parent_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parent_Id)), __LINE__);
        }
        $this->Parent_Id = $parent_Id;
        return $this;
    }
    /**
     * Get MatchesGifts value
     * @return bool
     */
    public function getMatchesGifts()
    {
        return $this->MatchesGifts;
    }
    /**
     * Set MatchesGifts value
     * @param bool $matchesGifts
     * @return \StructType\OrganizationDetail
     */
    public function setMatchesGifts($matchesGifts = null)
    {
        // validation for constraint: boolean
        if (!is_null($matchesGifts) && !is_bool($matchesGifts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($matchesGifts)), __LINE__);
        }
        $this->MatchesGifts = $matchesGifts;
        return $this;
    }
    /**
     * Get GiftMatchingRatio value
     * @return float
     */
    public function getGiftMatchingRatio()
    {
        return $this->GiftMatchingRatio;
    }
    /**
     * Set GiftMatchingRatio value
     * @param float $giftMatchingRatio
     * @return \StructType\OrganizationDetail
     */
    public function setGiftMatchingRatio($giftMatchingRatio = null)
    {
        $this->GiftMatchingRatio = $giftMatchingRatio;
        return $this;
    }
    /**
     * Get GiftMatchingRangeMinimum value
     * @return float
     */
    public function getGiftMatchingRangeMinimum()
    {
        return $this->GiftMatchingRangeMinimum;
    }
    /**
     * Set GiftMatchingRangeMinimum value
     * @param float $giftMatchingRangeMinimum
     * @return \StructType\OrganizationDetail
     */
    public function setGiftMatchingRangeMinimum($giftMatchingRangeMinimum = null)
    {
        $this->GiftMatchingRangeMinimum = $giftMatchingRangeMinimum;
        return $this;
    }
    /**
     * Get GiftMatchingRangeMaximum value
     * @return float
     */
    public function getGiftMatchingRangeMaximum()
    {
        return $this->GiftMatchingRangeMaximum;
    }
    /**
     * Set GiftMatchingRangeMaximum value
     * @param float $giftMatchingRangeMaximum
     * @return \StructType\OrganizationDetail
     */
    public function setGiftMatchingRangeMaximum($giftMatchingRangeMaximum = null)
    {
        $this->GiftMatchingRangeMaximum = $giftMatchingRangeMaximum;
        return $this;
    }
    /**
     * Get GiftMatchingMaximumGift value
     * @return float
     */
    public function getGiftMatchingMaximumGift()
    {
        return $this->GiftMatchingMaximumGift;
    }
    /**
     * Set GiftMatchingMaximumGift value
     * @param float $giftMatchingMaximumGift
     * @return \StructType\OrganizationDetail
     */
    public function setGiftMatchingMaximumGift($giftMatchingMaximumGift = null)
    {
        $this->GiftMatchingMaximumGift = $giftMatchingMaximumGift;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\OrganizationDetail
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\OrganizationType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\OrganizationType $type
     * @return \StructType\OrganizationDetail
     */
    public function setType(\StructType\OrganizationType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Industry value
     * @return \StructType\IndustryDetail|null
     */
    public function getIndustry()
    {
        return $this->Industry;
    }
    /**
     * Set Industry value
     * @param \StructType\IndustryDetail $industry
     * @return \StructType\OrganizationDetail
     */
    public function setIndustry(\StructType\IndustryDetail $industry = null)
    {
        $this->Industry = $industry;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrganizationDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
