<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitiativeRecord StructType
 * @subpackage Structs
 */
class InitiativeRecord extends NamedDataRecord
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The Campaign
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CampaignDetail
     */
    public $Campaign;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MessageDetail
     */
    public $Message;
    /**
     * The Audience
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AudienceCollection
     */
    public $Audience;
    /**
     * Constructor method for InitiativeRecord
     * @uses InitiativeRecord::setStatus()
     * @uses InitiativeRecord::setCampaign()
     * @uses InitiativeRecord::setMessage()
     * @uses InitiativeRecord::setAudience()
     * @param string $status
     * @param \StructType\CampaignDetail $campaign
     * @param \StructType\MessageDetail $message
     * @param \StructType\AudienceCollection $audience
     */
    public function __construct($status = null, \StructType\CampaignDetail $campaign = null, \StructType\MessageDetail $message = null, \StructType\AudienceCollection $audience = null)
    {
        $this
            ->setStatus($status)
            ->setCampaign($campaign)
            ->setMessage($message)
            ->setAudience($audience);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\InitiativeStatuses::valueIsValid()
     * @uses \EnumType\InitiativeStatuses::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\InitiativeRecord
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InitiativeStatuses::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\InitiativeStatuses::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Campaign value
     * @return \StructType\CampaignDetail|null
     */
    public function getCampaign()
    {
        return $this->Campaign;
    }
    /**
     * Set Campaign value
     * @param \StructType\CampaignDetail $campaign
     * @return \StructType\InitiativeRecord
     */
    public function setCampaign(\StructType\CampaignDetail $campaign = null)
    {
        $this->Campaign = $campaign;
        return $this;
    }
    /**
     * Get Message value
     * @return \StructType\MessageDetail|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param \StructType\MessageDetail $message
     * @return \StructType\InitiativeRecord
     */
    public function setMessage(\StructType\MessageDetail $message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Audience value
     * @return \StructType\AudienceCollection|null
     */
    public function getAudience()
    {
        return $this->Audience;
    }
    /**
     * Set Audience value
     * @param \StructType\AudienceCollection $audience
     * @return \StructType\InitiativeRecord
     */
    public function setAudience(\StructType\AudienceCollection $audience = null)
    {
        $this->Audience = $audience;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InitiativeRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
