<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitiativeConversionRecord StructType
 * @subpackage Structs
 */
class InitiativeConversionRecord extends DataRecord
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Revenue
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Revenue;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $Contact;
    /**
     * The Initiative
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InitiativeDetail
     */
    public $Initiative;
    /**
     * Constructor method for InitiativeConversionRecord
     * @uses InitiativeConversionRecord::setType()
     * @uses InitiativeConversionRecord::setRevenue()
     * @uses InitiativeConversionRecord::setContact()
     * @uses InitiativeConversionRecord::setInitiative()
     * @param string $type
     * @param float $revenue
     * @param \StructType\ContactSummary $contact
     * @param \StructType\InitiativeDetail $initiative
     */
    public function __construct($type = null, $revenue = null, \StructType\ContactSummary $contact = null, \StructType\InitiativeDetail $initiative = null)
    {
        $this
            ->setType($type)
            ->setRevenue($revenue)
            ->setContact($contact)
            ->setInitiative($initiative);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\InitiativeConversionTypes::valueIsValid()
     * @uses \EnumType\InitiativeConversionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\InitiativeConversionRecord
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InitiativeConversionTypes::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\InitiativeConversionTypes::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Revenue value
     * @return float
     */
    public function getRevenue()
    {
        return $this->Revenue;
    }
    /**
     * Set Revenue value
     * @param float $revenue
     * @return \StructType\InitiativeConversionRecord
     */
    public function setRevenue($revenue = null)
    {
        $this->Revenue = $revenue;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\ContactSummary|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\ContactSummary $contact
     * @return \StructType\InitiativeConversionRecord
     */
    public function setContact(\StructType\ContactSummary $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Initiative value
     * @return \StructType\InitiativeDetail|null
     */
    public function getInitiative()
    {
        return $this->Initiative;
    }
    /**
     * Set Initiative value
     * @param \StructType\InitiativeDetail $initiative
     * @return \StructType\InitiativeConversionRecord
     */
    public function setInitiative(\StructType\InitiativeDetail $initiative = null)
    {
        $this->Initiative = $initiative;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InitiativeConversionRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
