<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseholdDetail StructType
 * @subpackage Structs
 */
class HouseholdDetail extends DependentMetaData
{
    /**
     * The HeadContact_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $HeadContact_Id;
    /**
     * The SpouseContact_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $SpouseContact_Id;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The HeadContactName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HeadContactName;
    /**
     * The SpouseContactName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SpouseContactName;
    /**
     * Constructor method for HouseholdDetail
     * @uses HouseholdDetail::setHeadContact_Id()
     * @uses HouseholdDetail::setSpouseContact_Id()
     * @uses HouseholdDetail::setName()
     * @uses HouseholdDetail::setHeadContactName()
     * @uses HouseholdDetail::setSpouseContactName()
     * @param int $headContact_Id
     * @param int $spouseContact_Id
     * @param string $name
     * @param string $headContactName
     * @param string $spouseContactName
     */
    public function __construct($headContact_Id = null, $spouseContact_Id = null, $name = null, $headContactName = null, $spouseContactName = null)
    {
        $this
            ->setHeadContact_Id($headContact_Id)
            ->setSpouseContact_Id($spouseContact_Id)
            ->setName($name)
            ->setHeadContactName($headContactName)
            ->setSpouseContactName($spouseContactName);
    }
    /**
     * Get HeadContact_Id value
     * @return int
     */
    public function getHeadContact_Id()
    {
        return $this->HeadContact_Id;
    }
    /**
     * Set HeadContact_Id value
     * @param int $headContact_Id
     * @return \StructType\HouseholdDetail
     */
    public function setHeadContact_Id($headContact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($headContact_Id) && !is_numeric($headContact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($headContact_Id)), __LINE__);
        }
        $this->HeadContact_Id = $headContact_Id;
        return $this;
    }
    /**
     * Get SpouseContact_Id value
     * @return int
     */
    public function getSpouseContact_Id()
    {
        return $this->SpouseContact_Id;
    }
    /**
     * Set SpouseContact_Id value
     * @param int $spouseContact_Id
     * @return \StructType\HouseholdDetail
     */
    public function setSpouseContact_Id($spouseContact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($spouseContact_Id) && !is_numeric($spouseContact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($spouseContact_Id)), __LINE__);
        }
        $this->SpouseContact_Id = $spouseContact_Id;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\HouseholdDetail
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get HeadContactName value
     * @return string|null
     */
    public function getHeadContactName()
    {
        return $this->HeadContactName;
    }
    /**
     * Set HeadContactName value
     * @param string $headContactName
     * @return \StructType\HouseholdDetail
     */
    public function setHeadContactName($headContactName = null)
    {
        // validation for constraint: string
        if (!is_null($headContactName) && !is_string($headContactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($headContactName)), __LINE__);
        }
        $this->HeadContactName = $headContactName;
        return $this;
    }
    /**
     * Get SpouseContactName value
     * @return string|null
     */
    public function getSpouseContactName()
    {
        return $this->SpouseContactName;
    }
    /**
     * Set SpouseContactName value
     * @param string $spouseContactName
     * @return \StructType\HouseholdDetail
     */
    public function setSpouseContactName($spouseContactName = null)
    {
        // validation for constraint: string
        if (!is_null($spouseContactName) && !is_string($spouseContactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($spouseContactName)), __LINE__);
        }
        $this->SpouseContactName = $spouseContactName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseholdDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
