<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTributesQuery StructType
 * @subpackage Structs
 */
class GetTributesQuery extends DateAdvancedPagingQuery
{
    /**
     * The Tribute_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Tribute_Id;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for GetTributesQuery
     * @uses GetTributesQuery::setTribute_Id()
     * @uses GetTributesQuery::setType()
     * @uses GetTributesQuery::setActive()
     * @uses GetTributesQuery::setName()
     * @param int $tribute_Id
     * @param string $type
     * @param bool $active
     * @param string $name
     */
    public function __construct($tribute_Id = null, $type = null, $active = null, $name = null)
    {
        $this
            ->setTribute_Id($tribute_Id)
            ->setType($type)
            ->setActive($active)
            ->setName($name);
    }
    /**
     * Get Tribute_Id value
     * @return int
     */
    public function getTribute_Id()
    {
        return $this->Tribute_Id;
    }
    /**
     * Set Tribute_Id value
     * @param int $tribute_Id
     * @return \StructType\GetTributesQuery
     */
    public function setTribute_Id($tribute_Id = null)
    {
        // validation for constraint: int
        if (!is_null($tribute_Id) && !is_numeric($tribute_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tribute_Id)), __LINE__);
        }
        $this->Tribute_Id = $tribute_Id;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\TributeTypes::valueIsValid()
     * @uses \EnumType\TributeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\GetTributesQuery
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TributeTypes::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\TributeTypes::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\GetTributesQuery
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\GetTributesQuery
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetTributesQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
