<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTransactionsQuery StructType
 * @subpackage Structs
 */
class GetTransactionsQuery extends DateAdvancedPagingQuery
{
    /**
     * The Transaction_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Transaction_Id;
    /**
     * The Contact_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Contact_Id;
    /**
     * The IsPaid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsPaid;
    /**
     * The Form_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Form_Id;
    /**
     * The Category_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Category_Id;
    /**
     * The Sustainer_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Sustainer_Id;
    /**
     * The Pledge_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Pledge_Id;
    /**
     * The Membership_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Membership_Id;
    /**
     * The AmountFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmountFrom;
    /**
     * The AmountTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmountTo;
    /**
     * The AddressStateProvince_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AddressStateProvince_Id;
    /**
     * The AddressCountry_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AddressCountry_Id;
    /**
     * The PaymentMethod_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PaymentMethod_Id;
    /**
     * The GeneralLedgerCode_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $GeneralLedgerCode_Id;
    /**
     * The Fund_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Fund_Id;
    /**
     * The CampaignInitiative_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CampaignInitiative_Id;
    /**
     * The ResponseChannel_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ResponseChannel_Id;
    /**
     * The Tribute_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Tribute_Id;
    /**
     * The Event_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Event_Id;
    /**
     * The GrassrootEvent_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $GrassrootEvent_Id;
    /**
     * The PeerToPeerPage_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PeerToPeerPage_Id;
    /**
     * The PeerToPeerTeam_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PeerToPeerTeam_Id;
    /**
     * The PeerToPeerMicrosite_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PeerToPeerMicrosite_Id;
    /**
     * The TransactionDateFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TransactionDateFrom;
    /**
     * The TransactionDateTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TransactionDateTo;
    /**
     * The OrganizationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrganizationName;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The AddressCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressCity;
    /**
     * The AddressPostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressPostalCode;
    /**
     * Constructor method for GetTransactionsQuery
     * @uses GetTransactionsQuery::setTransaction_Id()
     * @uses GetTransactionsQuery::setContact_Id()
     * @uses GetTransactionsQuery::setIsPaid()
     * @uses GetTransactionsQuery::setForm_Id()
     * @uses GetTransactionsQuery::setCategory_Id()
     * @uses GetTransactionsQuery::setSustainer_Id()
     * @uses GetTransactionsQuery::setPledge_Id()
     * @uses GetTransactionsQuery::setMembership_Id()
     * @uses GetTransactionsQuery::setAmountFrom()
     * @uses GetTransactionsQuery::setAmountTo()
     * @uses GetTransactionsQuery::setAddressStateProvince_Id()
     * @uses GetTransactionsQuery::setAddressCountry_Id()
     * @uses GetTransactionsQuery::setPaymentMethod_Id()
     * @uses GetTransactionsQuery::setGeneralLedgerCode_Id()
     * @uses GetTransactionsQuery::setFund_Id()
     * @uses GetTransactionsQuery::setCampaignInitiative_Id()
     * @uses GetTransactionsQuery::setResponseChannel_Id()
     * @uses GetTransactionsQuery::setTribute_Id()
     * @uses GetTransactionsQuery::setEvent_Id()
     * @uses GetTransactionsQuery::setGrassrootEvent_Id()
     * @uses GetTransactionsQuery::setPeerToPeerPage_Id()
     * @uses GetTransactionsQuery::setPeerToPeerTeam_Id()
     * @uses GetTransactionsQuery::setPeerToPeerMicrosite_Id()
     * @uses GetTransactionsQuery::setTransactionDateFrom()
     * @uses GetTransactionsQuery::setTransactionDateTo()
     * @uses GetTransactionsQuery::setOrganizationName()
     * @uses GetTransactionsQuery::setFirstName()
     * @uses GetTransactionsQuery::setLastName()
     * @uses GetTransactionsQuery::setEmailAddress()
     * @uses GetTransactionsQuery::setAddressCity()
     * @uses GetTransactionsQuery::setAddressPostalCode()
     * @param int $transaction_Id
     * @param int $contact_Id
     * @param bool $isPaid
     * @param int $form_Id
     * @param int $category_Id
     * @param int $sustainer_Id
     * @param int $pledge_Id
     * @param int $membership_Id
     * @param float $amountFrom
     * @param float $amountTo
     * @param int $addressStateProvince_Id
     * @param int $addressCountry_Id
     * @param int $paymentMethod_Id
     * @param int $generalLedgerCode_Id
     * @param int $fund_Id
     * @param int $campaignInitiative_Id
     * @param int $responseChannel_Id
     * @param int $tribute_Id
     * @param int $event_Id
     * @param int $grassrootEvent_Id
     * @param int $peerToPeerPage_Id
     * @param int $peerToPeerTeam_Id
     * @param int $peerToPeerMicrosite_Id
     * @param string $transactionDateFrom
     * @param string $transactionDateTo
     * @param string $organizationName
     * @param string $firstName
     * @param string $lastName
     * @param string $emailAddress
     * @param string $addressCity
     * @param string $addressPostalCode
     */
    public function __construct($transaction_Id = null, $contact_Id = null, $isPaid = null, $form_Id = null, $category_Id = null, $sustainer_Id = null, $pledge_Id = null, $membership_Id = null, $amountFrom = null, $amountTo = null, $addressStateProvince_Id = null, $addressCountry_Id = null, $paymentMethod_Id = null, $generalLedgerCode_Id = null, $fund_Id = null, $campaignInitiative_Id = null, $responseChannel_Id = null, $tribute_Id = null, $event_Id = null, $grassrootEvent_Id = null, $peerToPeerPage_Id = null, $peerToPeerTeam_Id = null, $peerToPeerMicrosite_Id = null, $transactionDateFrom = null, $transactionDateTo = null, $organizationName = null, $firstName = null, $lastName = null, $emailAddress = null, $addressCity = null, $addressPostalCode = null)
    {
        $this
            ->setTransaction_Id($transaction_Id)
            ->setContact_Id($contact_Id)
            ->setIsPaid($isPaid)
            ->setForm_Id($form_Id)
            ->setCategory_Id($category_Id)
            ->setSustainer_Id($sustainer_Id)
            ->setPledge_Id($pledge_Id)
            ->setMembership_Id($membership_Id)
            ->setAmountFrom($amountFrom)
            ->setAmountTo($amountTo)
            ->setAddressStateProvince_Id($addressStateProvince_Id)
            ->setAddressCountry_Id($addressCountry_Id)
            ->setPaymentMethod_Id($paymentMethod_Id)
            ->setGeneralLedgerCode_Id($generalLedgerCode_Id)
            ->setFund_Id($fund_Id)
            ->setCampaignInitiative_Id($campaignInitiative_Id)
            ->setResponseChannel_Id($responseChannel_Id)
            ->setTribute_Id($tribute_Id)
            ->setEvent_Id($event_Id)
            ->setGrassrootEvent_Id($grassrootEvent_Id)
            ->setPeerToPeerPage_Id($peerToPeerPage_Id)
            ->setPeerToPeerTeam_Id($peerToPeerTeam_Id)
            ->setPeerToPeerMicrosite_Id($peerToPeerMicrosite_Id)
            ->setTransactionDateFrom($transactionDateFrom)
            ->setTransactionDateTo($transactionDateTo)
            ->setOrganizationName($organizationName)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setEmailAddress($emailAddress)
            ->setAddressCity($addressCity)
            ->setAddressPostalCode($addressPostalCode);
    }
    /**
     * Get Transaction_Id value
     * @return int
     */
    public function getTransaction_Id()
    {
        return $this->Transaction_Id;
    }
    /**
     * Set Transaction_Id value
     * @param int $transaction_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setTransaction_Id($transaction_Id = null)
    {
        // validation for constraint: int
        if (!is_null($transaction_Id) && !is_numeric($transaction_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transaction_Id)), __LINE__);
        }
        $this->Transaction_Id = $transaction_Id;
        return $this;
    }
    /**
     * Get Contact_Id value
     * @return int
     */
    public function getContact_Id()
    {
        return $this->Contact_Id;
    }
    /**
     * Set Contact_Id value
     * @param int $contact_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setContact_Id($contact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($contact_Id) && !is_numeric($contact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contact_Id)), __LINE__);
        }
        $this->Contact_Id = $contact_Id;
        return $this;
    }
    /**
     * Get IsPaid value
     * @return bool
     */
    public function getIsPaid()
    {
        return $this->IsPaid;
    }
    /**
     * Set IsPaid value
     * @param bool $isPaid
     * @return \StructType\GetTransactionsQuery
     */
    public function setIsPaid($isPaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPaid) && !is_bool($isPaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPaid)), __LINE__);
        }
        $this->IsPaid = $isPaid;
        return $this;
    }
    /**
     * Get Form_Id value
     * @return int
     */
    public function getForm_Id()
    {
        return $this->Form_Id;
    }
    /**
     * Set Form_Id value
     * @param int $form_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setForm_Id($form_Id = null)
    {
        // validation for constraint: int
        if (!is_null($form_Id) && !is_numeric($form_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($form_Id)), __LINE__);
        }
        $this->Form_Id = $form_Id;
        return $this;
    }
    /**
     * Get Category_Id value
     * @return int
     */
    public function getCategory_Id()
    {
        return $this->Category_Id;
    }
    /**
     * Set Category_Id value
     * @param int $category_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setCategory_Id($category_Id = null)
    {
        // validation for constraint: int
        if (!is_null($category_Id) && !is_numeric($category_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($category_Id)), __LINE__);
        }
        $this->Category_Id = $category_Id;
        return $this;
    }
    /**
     * Get Sustainer_Id value
     * @return int
     */
    public function getSustainer_Id()
    {
        return $this->Sustainer_Id;
    }
    /**
     * Set Sustainer_Id value
     * @param int $sustainer_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setSustainer_Id($sustainer_Id = null)
    {
        // validation for constraint: int
        if (!is_null($sustainer_Id) && !is_numeric($sustainer_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sustainer_Id)), __LINE__);
        }
        $this->Sustainer_Id = $sustainer_Id;
        return $this;
    }
    /**
     * Get Pledge_Id value
     * @return int
     */
    public function getPledge_Id()
    {
        return $this->Pledge_Id;
    }
    /**
     * Set Pledge_Id value
     * @param int $pledge_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setPledge_Id($pledge_Id = null)
    {
        // validation for constraint: int
        if (!is_null($pledge_Id) && !is_numeric($pledge_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pledge_Id)), __LINE__);
        }
        $this->Pledge_Id = $pledge_Id;
        return $this;
    }
    /**
     * Get Membership_Id value
     * @return int
     */
    public function getMembership_Id()
    {
        return $this->Membership_Id;
    }
    /**
     * Set Membership_Id value
     * @param int $membership_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setMembership_Id($membership_Id = null)
    {
        // validation for constraint: int
        if (!is_null($membership_Id) && !is_numeric($membership_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($membership_Id)), __LINE__);
        }
        $this->Membership_Id = $membership_Id;
        return $this;
    }
    /**
     * Get AmountFrom value
     * @return float
     */
    public function getAmountFrom()
    {
        return $this->AmountFrom;
    }
    /**
     * Set AmountFrom value
     * @param float $amountFrom
     * @return \StructType\GetTransactionsQuery
     */
    public function setAmountFrom($amountFrom = null)
    {
        $this->AmountFrom = $amountFrom;
        return $this;
    }
    /**
     * Get AmountTo value
     * @return float
     */
    public function getAmountTo()
    {
        return $this->AmountTo;
    }
    /**
     * Set AmountTo value
     * @param float $amountTo
     * @return \StructType\GetTransactionsQuery
     */
    public function setAmountTo($amountTo = null)
    {
        $this->AmountTo = $amountTo;
        return $this;
    }
    /**
     * Get AddressStateProvince_Id value
     * @return int
     */
    public function getAddressStateProvince_Id()
    {
        return $this->AddressStateProvince_Id;
    }
    /**
     * Set AddressStateProvince_Id value
     * @param int $addressStateProvince_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setAddressStateProvince_Id($addressStateProvince_Id = null)
    {
        // validation for constraint: int
        if (!is_null($addressStateProvince_Id) && !is_numeric($addressStateProvince_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($addressStateProvince_Id)), __LINE__);
        }
        $this->AddressStateProvince_Id = $addressStateProvince_Id;
        return $this;
    }
    /**
     * Get AddressCountry_Id value
     * @return int
     */
    public function getAddressCountry_Id()
    {
        return $this->AddressCountry_Id;
    }
    /**
     * Set AddressCountry_Id value
     * @param int $addressCountry_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setAddressCountry_Id($addressCountry_Id = null)
    {
        // validation for constraint: int
        if (!is_null($addressCountry_Id) && !is_numeric($addressCountry_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($addressCountry_Id)), __LINE__);
        }
        $this->AddressCountry_Id = $addressCountry_Id;
        return $this;
    }
    /**
     * Get PaymentMethod_Id value
     * @return int
     */
    public function getPaymentMethod_Id()
    {
        return $this->PaymentMethod_Id;
    }
    /**
     * Set PaymentMethod_Id value
     * @param int $paymentMethod_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setPaymentMethod_Id($paymentMethod_Id = null)
    {
        // validation for constraint: int
        if (!is_null($paymentMethod_Id) && !is_numeric($paymentMethod_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentMethod_Id)), __LINE__);
        }
        $this->PaymentMethod_Id = $paymentMethod_Id;
        return $this;
    }
    /**
     * Get GeneralLedgerCode_Id value
     * @return int
     */
    public function getGeneralLedgerCode_Id()
    {
        return $this->GeneralLedgerCode_Id;
    }
    /**
     * Set GeneralLedgerCode_Id value
     * @param int $generalLedgerCode_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setGeneralLedgerCode_Id($generalLedgerCode_Id = null)
    {
        // validation for constraint: int
        if (!is_null($generalLedgerCode_Id) && !is_numeric($generalLedgerCode_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($generalLedgerCode_Id)), __LINE__);
        }
        $this->GeneralLedgerCode_Id = $generalLedgerCode_Id;
        return $this;
    }
    /**
     * Get Fund_Id value
     * @return int
     */
    public function getFund_Id()
    {
        return $this->Fund_Id;
    }
    /**
     * Set Fund_Id value
     * @param int $fund_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setFund_Id($fund_Id = null)
    {
        // validation for constraint: int
        if (!is_null($fund_Id) && !is_numeric($fund_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fund_Id)), __LINE__);
        }
        $this->Fund_Id = $fund_Id;
        return $this;
    }
    /**
     * Get CampaignInitiative_Id value
     * @return int
     */
    public function getCampaignInitiative_Id()
    {
        return $this->CampaignInitiative_Id;
    }
    /**
     * Set CampaignInitiative_Id value
     * @param int $campaignInitiative_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setCampaignInitiative_Id($campaignInitiative_Id = null)
    {
        // validation for constraint: int
        if (!is_null($campaignInitiative_Id) && !is_numeric($campaignInitiative_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($campaignInitiative_Id)), __LINE__);
        }
        $this->CampaignInitiative_Id = $campaignInitiative_Id;
        return $this;
    }
    /**
     * Get ResponseChannel_Id value
     * @return int
     */
    public function getResponseChannel_Id()
    {
        return $this->ResponseChannel_Id;
    }
    /**
     * Set ResponseChannel_Id value
     * @param int $responseChannel_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setResponseChannel_Id($responseChannel_Id = null)
    {
        // validation for constraint: int
        if (!is_null($responseChannel_Id) && !is_numeric($responseChannel_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($responseChannel_Id)), __LINE__);
        }
        $this->ResponseChannel_Id = $responseChannel_Id;
        return $this;
    }
    /**
     * Get Tribute_Id value
     * @return int
     */
    public function getTribute_Id()
    {
        return $this->Tribute_Id;
    }
    /**
     * Set Tribute_Id value
     * @param int $tribute_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setTribute_Id($tribute_Id = null)
    {
        // validation for constraint: int
        if (!is_null($tribute_Id) && !is_numeric($tribute_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tribute_Id)), __LINE__);
        }
        $this->Tribute_Id = $tribute_Id;
        return $this;
    }
    /**
     * Get Event_Id value
     * @return int
     */
    public function getEvent_Id()
    {
        return $this->Event_Id;
    }
    /**
     * Set Event_Id value
     * @param int $event_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setEvent_Id($event_Id = null)
    {
        // validation for constraint: int
        if (!is_null($event_Id) && !is_numeric($event_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($event_Id)), __LINE__);
        }
        $this->Event_Id = $event_Id;
        return $this;
    }
    /**
     * Get GrassrootEvent_Id value
     * @return int
     */
    public function getGrassrootEvent_Id()
    {
        return $this->GrassrootEvent_Id;
    }
    /**
     * Set GrassrootEvent_Id value
     * @param int $grassrootEvent_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setGrassrootEvent_Id($grassrootEvent_Id = null)
    {
        // validation for constraint: int
        if (!is_null($grassrootEvent_Id) && !is_numeric($grassrootEvent_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($grassrootEvent_Id)), __LINE__);
        }
        $this->GrassrootEvent_Id = $grassrootEvent_Id;
        return $this;
    }
    /**
     * Get PeerToPeerPage_Id value
     * @return int
     */
    public function getPeerToPeerPage_Id()
    {
        return $this->PeerToPeerPage_Id;
    }
    /**
     * Set PeerToPeerPage_Id value
     * @param int $peerToPeerPage_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setPeerToPeerPage_Id($peerToPeerPage_Id = null)
    {
        // validation for constraint: int
        if (!is_null($peerToPeerPage_Id) && !is_numeric($peerToPeerPage_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($peerToPeerPage_Id)), __LINE__);
        }
        $this->PeerToPeerPage_Id = $peerToPeerPage_Id;
        return $this;
    }
    /**
     * Get PeerToPeerTeam_Id value
     * @return int
     */
    public function getPeerToPeerTeam_Id()
    {
        return $this->PeerToPeerTeam_Id;
    }
    /**
     * Set PeerToPeerTeam_Id value
     * @param int $peerToPeerTeam_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setPeerToPeerTeam_Id($peerToPeerTeam_Id = null)
    {
        // validation for constraint: int
        if (!is_null($peerToPeerTeam_Id) && !is_numeric($peerToPeerTeam_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($peerToPeerTeam_Id)), __LINE__);
        }
        $this->PeerToPeerTeam_Id = $peerToPeerTeam_Id;
        return $this;
    }
    /**
     * Get PeerToPeerMicrosite_Id value
     * @return int
     */
    public function getPeerToPeerMicrosite_Id()
    {
        return $this->PeerToPeerMicrosite_Id;
    }
    /**
     * Set PeerToPeerMicrosite_Id value
     * @param int $peerToPeerMicrosite_Id
     * @return \StructType\GetTransactionsQuery
     */
    public function setPeerToPeerMicrosite_Id($peerToPeerMicrosite_Id = null)
    {
        // validation for constraint: int
        if (!is_null($peerToPeerMicrosite_Id) && !is_numeric($peerToPeerMicrosite_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($peerToPeerMicrosite_Id)), __LINE__);
        }
        $this->PeerToPeerMicrosite_Id = $peerToPeerMicrosite_Id;
        return $this;
    }
    /**
     * Get TransactionDateFrom value
     * @return string
     */
    public function getTransactionDateFrom()
    {
        return $this->TransactionDateFrom;
    }
    /**
     * Set TransactionDateFrom value
     * @param string $transactionDateFrom
     * @return \StructType\GetTransactionsQuery
     */
    public function setTransactionDateFrom($transactionDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDateFrom) && !is_string($transactionDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDateFrom)), __LINE__);
        }
        $this->TransactionDateFrom = $transactionDateFrom;
        return $this;
    }
    /**
     * Get TransactionDateTo value
     * @return string
     */
    public function getTransactionDateTo()
    {
        return $this->TransactionDateTo;
    }
    /**
     * Set TransactionDateTo value
     * @param string $transactionDateTo
     * @return \StructType\GetTransactionsQuery
     */
    public function setTransactionDateTo($transactionDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDateTo) && !is_string($transactionDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDateTo)), __LINE__);
        }
        $this->TransactionDateTo = $transactionDateTo;
        return $this;
    }
    /**
     * Get OrganizationName value
     * @return string|null
     */
    public function getOrganizationName()
    {
        return $this->OrganizationName;
    }
    /**
     * Set OrganizationName value
     * @param string $organizationName
     * @return \StructType\GetTransactionsQuery
     */
    public function setOrganizationName($organizationName = null)
    {
        // validation for constraint: string
        if (!is_null($organizationName) && !is_string($organizationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organizationName)), __LINE__);
        }
        $this->OrganizationName = $organizationName;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\GetTransactionsQuery
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\GetTransactionsQuery
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\GetTransactionsQuery
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get AddressCity value
     * @return string|null
     */
    public function getAddressCity()
    {
        return $this->AddressCity;
    }
    /**
     * Set AddressCity value
     * @param string $addressCity
     * @return \StructType\GetTransactionsQuery
     */
    public function setAddressCity($addressCity = null)
    {
        // validation for constraint: string
        if (!is_null($addressCity) && !is_string($addressCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressCity)), __LINE__);
        }
        $this->AddressCity = $addressCity;
        return $this;
    }
    /**
     * Get AddressPostalCode value
     * @return string|null
     */
    public function getAddressPostalCode()
    {
        return $this->AddressPostalCode;
    }
    /**
     * Set AddressPostalCode value
     * @param string $addressPostalCode
     * @return \StructType\GetTransactionsQuery
     */
    public function setAddressPostalCode($addressPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($addressPostalCode) && !is_string($addressPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressPostalCode)), __LINE__);
        }
        $this->AddressPostalCode = $addressPostalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetTransactionsQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
