<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSocialMediaHandlesQuery StructType
 * @subpackage Structs
 */
class GetSocialMediaHandlesQuery extends DateAdvancedPagingQuery
{
    /**
     * The SocialMediaHandle_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SocialMediaHandle_Id;
    /**
     * The Contact_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Contact_Id;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * Constructor method for GetSocialMediaHandlesQuery
     * @uses GetSocialMediaHandlesQuery::setSocialMediaHandle_Id()
     * @uses GetSocialMediaHandlesQuery::setContact_Id()
     * @uses GetSocialMediaHandlesQuery::setURL()
     * @param int $socialMediaHandle_Id
     * @param int $contact_Id
     * @param string $uRL
     */
    public function __construct($socialMediaHandle_Id = null, $contact_Id = null, $uRL = null)
    {
        $this
            ->setSocialMediaHandle_Id($socialMediaHandle_Id)
            ->setContact_Id($contact_Id)
            ->setURL($uRL);
    }
    /**
     * Get SocialMediaHandle_Id value
     * @return int
     */
    public function getSocialMediaHandle_Id()
    {
        return $this->SocialMediaHandle_Id;
    }
    /**
     * Set SocialMediaHandle_Id value
     * @param int $socialMediaHandle_Id
     * @return \StructType\GetSocialMediaHandlesQuery
     */
    public function setSocialMediaHandle_Id($socialMediaHandle_Id = null)
    {
        // validation for constraint: int
        if (!is_null($socialMediaHandle_Id) && !is_numeric($socialMediaHandle_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($socialMediaHandle_Id)), __LINE__);
        }
        $this->SocialMediaHandle_Id = $socialMediaHandle_Id;
        return $this;
    }
    /**
     * Get Contact_Id value
     * @return int
     */
    public function getContact_Id()
    {
        return $this->Contact_Id;
    }
    /**
     * Set Contact_Id value
     * @param int $contact_Id
     * @return \StructType\GetSocialMediaHandlesQuery
     */
    public function setContact_Id($contact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($contact_Id) && !is_numeric($contact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contact_Id)), __LINE__);
        }
        $this->Contact_Id = $contact_Id;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\GetSocialMediaHandlesQuery
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSocialMediaHandlesQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
