<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPhoneNumbersQuery StructType
 * @subpackage Structs
 */
class GetPhoneNumbersQuery extends DateAdvancedPagingQuery
{
    /**
     * The PhoneNumber_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PhoneNumber_Id;
    /**
     * The Contact_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Contact_Id;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * Constructor method for GetPhoneNumbersQuery
     * @uses GetPhoneNumbersQuery::setPhoneNumber_Id()
     * @uses GetPhoneNumbersQuery::setContact_Id()
     * @uses GetPhoneNumbersQuery::setPhoneNumber()
     * @param int $phoneNumber_Id
     * @param int $contact_Id
     * @param string $phoneNumber
     */
    public function __construct($phoneNumber_Id = null, $contact_Id = null, $phoneNumber = null)
    {
        $this
            ->setPhoneNumber_Id($phoneNumber_Id)
            ->setContact_Id($contact_Id)
            ->setPhoneNumber($phoneNumber);
    }
    /**
     * Get PhoneNumber_Id value
     * @return int
     */
    public function getPhoneNumber_Id()
    {
        return $this->PhoneNumber_Id;
    }
    /**
     * Set PhoneNumber_Id value
     * @param int $phoneNumber_Id
     * @return \StructType\GetPhoneNumbersQuery
     */
    public function setPhoneNumber_Id($phoneNumber_Id = null)
    {
        // validation for constraint: int
        if (!is_null($phoneNumber_Id) && !is_numeric($phoneNumber_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($phoneNumber_Id)), __LINE__);
        }
        $this->PhoneNumber_Id = $phoneNumber_Id;
        return $this;
    }
    /**
     * Get Contact_Id value
     * @return int
     */
    public function getContact_Id()
    {
        return $this->Contact_Id;
    }
    /**
     * Set Contact_Id value
     * @param int $contact_Id
     * @return \StructType\GetPhoneNumbersQuery
     */
    public function setContact_Id($contact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($contact_Id) && !is_numeric($contact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contact_Id)), __LINE__);
        }
        $this->Contact_Id = $contact_Id;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\GetPhoneNumbersQuery
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPhoneNumbersQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
