<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPeerToPeerPagesQuery StructType
 * @subpackage Structs
 */
class GetPeerToPeerPagesQuery extends DateAdvancedPagingQuery
{
    /**
     * The Page_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Page_Id;
    /**
     * The Microsite_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Microsite_Id;
    /**
     * The Team_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Team_Id;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * Constructor method for GetPeerToPeerPagesQuery
     * @uses GetPeerToPeerPagesQuery::setPage_Id()
     * @uses GetPeerToPeerPagesQuery::setMicrosite_Id()
     * @uses GetPeerToPeerPagesQuery::setTeam_Id()
     * @uses GetPeerToPeerPagesQuery::setActive()
     * @param int $page_Id
     * @param int $microsite_Id
     * @param int $team_Id
     * @param bool $active
     */
    public function __construct($page_Id = null, $microsite_Id = null, $team_Id = null, $active = null)
    {
        $this
            ->setPage_Id($page_Id)
            ->setMicrosite_Id($microsite_Id)
            ->setTeam_Id($team_Id)
            ->setActive($active);
    }
    /**
     * Get Page_Id value
     * @return int
     */
    public function getPage_Id()
    {
        return $this->Page_Id;
    }
    /**
     * Set Page_Id value
     * @param int $page_Id
     * @return \StructType\GetPeerToPeerPagesQuery
     */
    public function setPage_Id($page_Id = null)
    {
        // validation for constraint: int
        if (!is_null($page_Id) && !is_numeric($page_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($page_Id)), __LINE__);
        }
        $this->Page_Id = $page_Id;
        return $this;
    }
    /**
     * Get Microsite_Id value
     * @return int
     */
    public function getMicrosite_Id()
    {
        return $this->Microsite_Id;
    }
    /**
     * Set Microsite_Id value
     * @param int $microsite_Id
     * @return \StructType\GetPeerToPeerPagesQuery
     */
    public function setMicrosite_Id($microsite_Id = null)
    {
        // validation for constraint: int
        if (!is_null($microsite_Id) && !is_numeric($microsite_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($microsite_Id)), __LINE__);
        }
        $this->Microsite_Id = $microsite_Id;
        return $this;
    }
    /**
     * Get Team_Id value
     * @return int
     */
    public function getTeam_Id()
    {
        return $this->Team_Id;
    }
    /**
     * Set Team_Id value
     * @param int $team_Id
     * @return \StructType\GetPeerToPeerPagesQuery
     */
    public function setTeam_Id($team_Id = null)
    {
        // validation for constraint: int
        if (!is_null($team_Id) && !is_numeric($team_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($team_Id)), __LINE__);
        }
        $this->Team_Id = $team_Id;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\GetPeerToPeerPagesQuery
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPeerToPeerPagesQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
