<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOpportunitiesQuery StructType
 * @subpackage Structs
 */
class GetOpportunitiesQuery extends DateAdvancedPagingQuery
{
    /**
     * The ReturnOpportunityContacts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ReturnOpportunityContacts;
    /**
     * The ReturnOpportunitySolicitors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ReturnOpportunitySolicitors;
    /**
     * The Opportunity_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Opportunity_Id;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The Status_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Status_Id;
    /**
     * The OpportunityPriority_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OpportunityPriority_Id;
    /**
     * The OwnerPrimaryContact_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OwnerPrimaryContact_Id;
    /**
     * The TargetPrimaryContact_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TargetPrimaryContact_Id;
    /**
     * The EstimatedValueFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $EstimatedValueFrom;
    /**
     * The EstimatedValueTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $EstimatedValueTo;
    /**
     * The EstimatedCloseDateFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EstimatedCloseDateFrom;
    /**
     * The EstimatedCloseDateTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EstimatedCloseDateTo;
    /**
     * The OpportunityTypeTrack_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OpportunityTypeTrack_Id;
    /**
     * The CurrentStage_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CurrentStage_Id;
    /**
     * The CurrentOpportunityTrackStep_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CurrentOpportunityTrackStep_Id;
    /**
     * The OpportunityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OpportunityName;
    /**
     * Constructor method for GetOpportunitiesQuery
     * @uses GetOpportunitiesQuery::setReturnOpportunityContacts()
     * @uses GetOpportunitiesQuery::setReturnOpportunitySolicitors()
     * @uses GetOpportunitiesQuery::setOpportunity_Id()
     * @uses GetOpportunitiesQuery::setActive()
     * @uses GetOpportunitiesQuery::setStatus_Id()
     * @uses GetOpportunitiesQuery::setOpportunityPriority_Id()
     * @uses GetOpportunitiesQuery::setOwnerPrimaryContact_Id()
     * @uses GetOpportunitiesQuery::setTargetPrimaryContact_Id()
     * @uses GetOpportunitiesQuery::setEstimatedValueFrom()
     * @uses GetOpportunitiesQuery::setEstimatedValueTo()
     * @uses GetOpportunitiesQuery::setEstimatedCloseDateFrom()
     * @uses GetOpportunitiesQuery::setEstimatedCloseDateTo()
     * @uses GetOpportunitiesQuery::setOpportunityTypeTrack_Id()
     * @uses GetOpportunitiesQuery::setCurrentStage_Id()
     * @uses GetOpportunitiesQuery::setCurrentOpportunityTrackStep_Id()
     * @uses GetOpportunitiesQuery::setOpportunityName()
     * @param bool $returnOpportunityContacts
     * @param bool $returnOpportunitySolicitors
     * @param int $opportunity_Id
     * @param bool $active
     * @param int $status_Id
     * @param int $opportunityPriority_Id
     * @param int $ownerPrimaryContact_Id
     * @param int $targetPrimaryContact_Id
     * @param float $estimatedValueFrom
     * @param float $estimatedValueTo
     * @param string $estimatedCloseDateFrom
     * @param string $estimatedCloseDateTo
     * @param int $opportunityTypeTrack_Id
     * @param int $currentStage_Id
     * @param int $currentOpportunityTrackStep_Id
     * @param string $opportunityName
     */
    public function __construct($returnOpportunityContacts = null, $returnOpportunitySolicitors = null, $opportunity_Id = null, $active = null, $status_Id = null, $opportunityPriority_Id = null, $ownerPrimaryContact_Id = null, $targetPrimaryContact_Id = null, $estimatedValueFrom = null, $estimatedValueTo = null, $estimatedCloseDateFrom = null, $estimatedCloseDateTo = null, $opportunityTypeTrack_Id = null, $currentStage_Id = null, $currentOpportunityTrackStep_Id = null, $opportunityName = null)
    {
        $this
            ->setReturnOpportunityContacts($returnOpportunityContacts)
            ->setReturnOpportunitySolicitors($returnOpportunitySolicitors)
            ->setOpportunity_Id($opportunity_Id)
            ->setActive($active)
            ->setStatus_Id($status_Id)
            ->setOpportunityPriority_Id($opportunityPriority_Id)
            ->setOwnerPrimaryContact_Id($ownerPrimaryContact_Id)
            ->setTargetPrimaryContact_Id($targetPrimaryContact_Id)
            ->setEstimatedValueFrom($estimatedValueFrom)
            ->setEstimatedValueTo($estimatedValueTo)
            ->setEstimatedCloseDateFrom($estimatedCloseDateFrom)
            ->setEstimatedCloseDateTo($estimatedCloseDateTo)
            ->setOpportunityTypeTrack_Id($opportunityTypeTrack_Id)
            ->setCurrentStage_Id($currentStage_Id)
            ->setCurrentOpportunityTrackStep_Id($currentOpportunityTrackStep_Id)
            ->setOpportunityName($opportunityName);
    }
    /**
     * Get ReturnOpportunityContacts value
     * @return bool
     */
    public function getReturnOpportunityContacts()
    {
        return $this->ReturnOpportunityContacts;
    }
    /**
     * Set ReturnOpportunityContacts value
     * @param bool $returnOpportunityContacts
     * @return \StructType\GetOpportunitiesQuery
     */
    public function setReturnOpportunityContacts($returnOpportunityContacts = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnOpportunityContacts) && !is_bool($returnOpportunityContacts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnOpportunityContacts)), __LINE__);
        }
        $this->ReturnOpportunityContacts = $returnOpportunityContacts;
        return $this;
    }
    /**
     * Get ReturnOpportunitySolicitors value
     * @return bool
     */
    public function getReturnOpportunitySolicitors()
    {
        return $this->ReturnOpportunitySolicitors;
    }
    /**
     * Set ReturnOpportunitySolicitors value
     * @param bool $returnOpportunitySolicitors
     * @return \StructType\GetOpportunitiesQuery
     */
    public function setReturnOpportunitySolicitors($returnOpportunitySolicitors = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnOpportunitySolicitors) && !is_bool($returnOpportunitySolicitors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnOpportunitySolicitors)), __LINE__);
        }
        $this->ReturnOpportunitySolicitors = $returnOpportunitySolicitors;
        return $this;
    }
    /**
     * Get Opportunity_Id value
     * @return int
     */
    public function getOpportunity_Id()
    {
        return $this->Opportunity_Id;
    }
    /**
     * Set Opportunity_Id value
     * @param int $opportunity_Id
     * @return \StructType\GetOpportunitiesQuery
     */
    public function setOpportunity_Id($opportunity_Id = null)
    {
        // validation for constraint: int
        if (!is_null($opportunity_Id) && !is_numeric($opportunity_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($opportunity_Id)), __LINE__);
        }
        $this->Opportunity_Id = $opportunity_Id;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\GetOpportunitiesQuery
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Status_Id value
     * @return int
     */
    public function getStatus_Id()
    {
        return $this->Status_Id;
    }
    /**
     * Set Status_Id value
     * @param int $status_Id
     * @return \StructType\GetOpportunitiesQuery
     */
    public function setStatus_Id($status_Id = null)
    {
        // validation for constraint: int
        if (!is_null($status_Id) && !is_numeric($status_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status_Id)), __LINE__);
        }
        $this->Status_Id = $status_Id;
        return $this;
    }
    /**
     * Get OpportunityPriority_Id value
     * @return int
     */
    public function getOpportunityPriority_Id()
    {
        return $this->OpportunityPriority_Id;
    }
    /**
     * Set OpportunityPriority_Id value
     * @param int $opportunityPriority_Id
     * @return \StructType\GetOpportunitiesQuery
     */
    public function setOpportunityPriority_Id($opportunityPriority_Id = null)
    {
        // validation for constraint: int
        if (!is_null($opportunityPriority_Id) && !is_numeric($opportunityPriority_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($opportunityPriority_Id)), __LINE__);
        }
        $this->OpportunityPriority_Id = $opportunityPriority_Id;
        return $this;
    }
    /**
     * Get OwnerPrimaryContact_Id value
     * @return int
     */
    public function getOwnerPrimaryContact_Id()
    {
        return $this->OwnerPrimaryContact_Id;
    }
    /**
     * Set OwnerPrimaryContact_Id value
     * @param int $ownerPrimaryContact_Id
     * @return \StructType\GetOpportunitiesQuery
     */
    public function setOwnerPrimaryContact_Id($ownerPrimaryContact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($ownerPrimaryContact_Id) && !is_numeric($ownerPrimaryContact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ownerPrimaryContact_Id)), __LINE__);
        }
        $this->OwnerPrimaryContact_Id = $ownerPrimaryContact_Id;
        return $this;
    }
    /**
     * Get TargetPrimaryContact_Id value
     * @return int
     */
    public function getTargetPrimaryContact_Id()
    {
        return $this->TargetPrimaryContact_Id;
    }
    /**
     * Set TargetPrimaryContact_Id value
     * @param int $targetPrimaryContact_Id
     * @return \StructType\GetOpportunitiesQuery
     */
    public function setTargetPrimaryContact_Id($targetPrimaryContact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($targetPrimaryContact_Id) && !is_numeric($targetPrimaryContact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($targetPrimaryContact_Id)), __LINE__);
        }
        $this->TargetPrimaryContact_Id = $targetPrimaryContact_Id;
        return $this;
    }
    /**
     * Get EstimatedValueFrom value
     * @return float
     */
    public function getEstimatedValueFrom()
    {
        return $this->EstimatedValueFrom;
    }
    /**
     * Set EstimatedValueFrom value
     * @param float $estimatedValueFrom
     * @return \StructType\GetOpportunitiesQuery
     */
    public function setEstimatedValueFrom($estimatedValueFrom = null)
    {
        $this->EstimatedValueFrom = $estimatedValueFrom;
        return $this;
    }
    /**
     * Get EstimatedValueTo value
     * @return float
     */
    public function getEstimatedValueTo()
    {
        return $this->EstimatedValueTo;
    }
    /**
     * Set EstimatedValueTo value
     * @param float $estimatedValueTo
     * @return \StructType\GetOpportunitiesQuery
     */
    public function setEstimatedValueTo($estimatedValueTo = null)
    {
        $this->EstimatedValueTo = $estimatedValueTo;
        return $this;
    }
    /**
     * Get EstimatedCloseDateFrom value
     * @return string
     */
    public function getEstimatedCloseDateFrom()
    {
        return $this->EstimatedCloseDateFrom;
    }
    /**
     * Set EstimatedCloseDateFrom value
     * @param string $estimatedCloseDateFrom
     * @return \StructType\GetOpportunitiesQuery
     */
    public function setEstimatedCloseDateFrom($estimatedCloseDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedCloseDateFrom) && !is_string($estimatedCloseDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedCloseDateFrom)), __LINE__);
        }
        $this->EstimatedCloseDateFrom = $estimatedCloseDateFrom;
        return $this;
    }
    /**
     * Get EstimatedCloseDateTo value
     * @return string
     */
    public function getEstimatedCloseDateTo()
    {
        return $this->EstimatedCloseDateTo;
    }
    /**
     * Set EstimatedCloseDateTo value
     * @param string $estimatedCloseDateTo
     * @return \StructType\GetOpportunitiesQuery
     */
    public function setEstimatedCloseDateTo($estimatedCloseDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedCloseDateTo) && !is_string($estimatedCloseDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedCloseDateTo)), __LINE__);
        }
        $this->EstimatedCloseDateTo = $estimatedCloseDateTo;
        return $this;
    }
    /**
     * Get OpportunityTypeTrack_Id value
     * @return int
     */
    public function getOpportunityTypeTrack_Id()
    {
        return $this->OpportunityTypeTrack_Id;
    }
    /**
     * Set OpportunityTypeTrack_Id value
     * @param int $opportunityTypeTrack_Id
     * @return \StructType\GetOpportunitiesQuery
     */
    public function setOpportunityTypeTrack_Id($opportunityTypeTrack_Id = null)
    {
        // validation for constraint: int
        if (!is_null($opportunityTypeTrack_Id) && !is_numeric($opportunityTypeTrack_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($opportunityTypeTrack_Id)), __LINE__);
        }
        $this->OpportunityTypeTrack_Id = $opportunityTypeTrack_Id;
        return $this;
    }
    /**
     * Get CurrentStage_Id value
     * @return int
     */
    public function getCurrentStage_Id()
    {
        return $this->CurrentStage_Id;
    }
    /**
     * Set CurrentStage_Id value
     * @param int $currentStage_Id
     * @return \StructType\GetOpportunitiesQuery
     */
    public function setCurrentStage_Id($currentStage_Id = null)
    {
        // validation for constraint: int
        if (!is_null($currentStage_Id) && !is_numeric($currentStage_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentStage_Id)), __LINE__);
        }
        $this->CurrentStage_Id = $currentStage_Id;
        return $this;
    }
    /**
     * Get CurrentOpportunityTrackStep_Id value
     * @return int
     */
    public function getCurrentOpportunityTrackStep_Id()
    {
        return $this->CurrentOpportunityTrackStep_Id;
    }
    /**
     * Set CurrentOpportunityTrackStep_Id value
     * @param int $currentOpportunityTrackStep_Id
     * @return \StructType\GetOpportunitiesQuery
     */
    public function setCurrentOpportunityTrackStep_Id($currentOpportunityTrackStep_Id = null)
    {
        // validation for constraint: int
        if (!is_null($currentOpportunityTrackStep_Id) && !is_numeric($currentOpportunityTrackStep_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentOpportunityTrackStep_Id)), __LINE__);
        }
        $this->CurrentOpportunityTrackStep_Id = $currentOpportunityTrackStep_Id;
        return $this;
    }
    /**
     * Get OpportunityName value
     * @return string|null
     */
    public function getOpportunityName()
    {
        return $this->OpportunityName;
    }
    /**
     * Set OpportunityName value
     * @param string $opportunityName
     * @return \StructType\GetOpportunitiesQuery
     */
    public function setOpportunityName($opportunityName = null)
    {
        // validation for constraint: string
        if (!is_null($opportunityName) && !is_string($opportunityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opportunityName)), __LINE__);
        }
        $this->OpportunityName = $opportunityName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetOpportunitiesQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
