<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEmailAddressesQuery StructType
 * @subpackage Structs
 */
class GetEmailAddressesQuery extends DateAdvancedPagingQuery
{
    /**
     * The EmailAddress_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EmailAddress_Id;
    /**
     * The Contact_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Contact_Id;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * Constructor method for GetEmailAddressesQuery
     * @uses GetEmailAddressesQuery::setEmailAddress_Id()
     * @uses GetEmailAddressesQuery::setContact_Id()
     * @uses GetEmailAddressesQuery::setEmailAddress()
     * @param int $emailAddress_Id
     * @param int $contact_Id
     * @param string $emailAddress
     */
    public function __construct($emailAddress_Id = null, $contact_Id = null, $emailAddress = null)
    {
        $this
            ->setEmailAddress_Id($emailAddress_Id)
            ->setContact_Id($contact_Id)
            ->setEmailAddress($emailAddress);
    }
    /**
     * Get EmailAddress_Id value
     * @return int
     */
    public function getEmailAddress_Id()
    {
        return $this->EmailAddress_Id;
    }
    /**
     * Set EmailAddress_Id value
     * @param int $emailAddress_Id
     * @return \StructType\GetEmailAddressesQuery
     */
    public function setEmailAddress_Id($emailAddress_Id = null)
    {
        // validation for constraint: int
        if (!is_null($emailAddress_Id) && !is_numeric($emailAddress_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($emailAddress_Id)), __LINE__);
        }
        $this->EmailAddress_Id = $emailAddress_Id;
        return $this;
    }
    /**
     * Get Contact_Id value
     * @return int
     */
    public function getContact_Id()
    {
        return $this->Contact_Id;
    }
    /**
     * Set Contact_Id value
     * @param int $contact_Id
     * @return \StructType\GetEmailAddressesQuery
     */
    public function setContact_Id($contact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($contact_Id) && !is_numeric($contact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contact_Id)), __LINE__);
        }
        $this->Contact_Id = $contact_Id;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\GetEmailAddressesQuery
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEmailAddressesQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
