<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditRelationship StructType
 * @subpackage Structs
 */
class EditRelationship extends AbstractStructBase
{
    /**
     * The credentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WebServiceAuthentication
     */
    public $credentials;
    /**
     * The parameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EditRelationshipParameters
     */
    public $parameters;
    /**
     * Constructor method for EditRelationship
     * @uses EditRelationship::setCredentials()
     * @uses EditRelationship::setParameters()
     * @param \StructType\WebServiceAuthentication $credentials
     * @param \StructType\EditRelationshipParameters $parameters
     */
    public function __construct(\StructType\WebServiceAuthentication $credentials = null, \StructType\EditRelationshipParameters $parameters = null)
    {
        $this
            ->setCredentials($credentials)
            ->setParameters($parameters);
    }
    /**
     * Get credentials value
     * @return \StructType\WebServiceAuthentication|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\WebServiceAuthentication $credentials
     * @return \StructType\EditRelationship
     */
    public function setCredentials(\StructType\WebServiceAuthentication $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get parameters value
     * @return \StructType\EditRelationshipParameters|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \StructType\EditRelationshipParameters $parameters
     * @return \StructType\EditRelationship
     */
    public function setParameters(\StructType\EditRelationshipParameters $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditRelationship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
