<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditPersonParameters StructType
 * @subpackage Structs
 */
class EditPersonParameters extends EditRecordParameters
{
    /**
     * The Prefix_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Prefix_Id;
    /**
     * The Suffix_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Suffix_Id;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BirthDate;
    /**
     * The Gender
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The LanguagePreference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LanguagePreference;
    /**
     * The MailOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $MailOptIn;
    /**
     * The EmailOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $EmailOptIn;
    /**
     * The PhoneOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $PhoneOptIn;
    /**
     * The FaxOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $FaxOptIn;
    /**
     * The SmsOptIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $SmsOptIn;
    /**
     * The SyncType_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SyncType_Id;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiddleName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The PrimaryAddressStreet1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryAddressStreet1;
    /**
     * The PrimaryAddressStreet2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryAddressStreet2;
    /**
     * The PrimaryAddressCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryAddressCity;
    /**
     * The PrimaryAddressState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryAddressState;
    /**
     * The PrimaryAddressPostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryAddressPostalCode;
    /**
     * The PrimaryAddressCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryAddressCountry;
    /**
     * The PrimaryEmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryEmailAddress;
    /**
     * The PrimaryPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryPhone;
    /**
     * The PrimaryFax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimaryFax;
    /**
     * The PrimarySms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrimarySms;
    /**
     * The SyncExternalId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SyncExternalId;
    /**
     * The Groups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfChangeContactGroupParameters
     */
    public $Groups;
    /**
     * The Tags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfChangeContactTagParameters
     */
    public $Tags;
    /**
     * The OptInLists
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfChangeContactOptInListParameters
     */
    public $OptInLists;
    /**
     * The CustomFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEditContactCustomFieldParameters
     */
    public $CustomFields;
    /**
     * Constructor method for EditPersonParameters
     * @uses EditPersonParameters::setPrefix_Id()
     * @uses EditPersonParameters::setSuffix_Id()
     * @uses EditPersonParameters::setBirthDate()
     * @uses EditPersonParameters::setGender()
     * @uses EditPersonParameters::setLanguagePreference()
     * @uses EditPersonParameters::setMailOptIn()
     * @uses EditPersonParameters::setEmailOptIn()
     * @uses EditPersonParameters::setPhoneOptIn()
     * @uses EditPersonParameters::setFaxOptIn()
     * @uses EditPersonParameters::setSmsOptIn()
     * @uses EditPersonParameters::setSyncType_Id()
     * @uses EditPersonParameters::setFirstName()
     * @uses EditPersonParameters::setMiddleName()
     * @uses EditPersonParameters::setLastName()
     * @uses EditPersonParameters::setPrimaryAddressStreet1()
     * @uses EditPersonParameters::setPrimaryAddressStreet2()
     * @uses EditPersonParameters::setPrimaryAddressCity()
     * @uses EditPersonParameters::setPrimaryAddressState()
     * @uses EditPersonParameters::setPrimaryAddressPostalCode()
     * @uses EditPersonParameters::setPrimaryAddressCountry()
     * @uses EditPersonParameters::setPrimaryEmailAddress()
     * @uses EditPersonParameters::setPrimaryPhone()
     * @uses EditPersonParameters::setPrimaryFax()
     * @uses EditPersonParameters::setPrimarySms()
     * @uses EditPersonParameters::setSyncExternalId()
     * @uses EditPersonParameters::setGroups()
     * @uses EditPersonParameters::setTags()
     * @uses EditPersonParameters::setOptInLists()
     * @uses EditPersonParameters::setCustomFields()
     * @param int $prefix_Id
     * @param int $suffix_Id
     * @param string $birthDate
     * @param string $gender
     * @param string $languagePreference
     * @param bool $mailOptIn
     * @param bool $emailOptIn
     * @param bool $phoneOptIn
     * @param bool $faxOptIn
     * @param bool $smsOptIn
     * @param int $syncType_Id
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     * @param string $primaryAddressStreet1
     * @param string $primaryAddressStreet2
     * @param string $primaryAddressCity
     * @param string $primaryAddressState
     * @param string $primaryAddressPostalCode
     * @param string $primaryAddressCountry
     * @param string $primaryEmailAddress
     * @param string $primaryPhone
     * @param string $primaryFax
     * @param string $primarySms
     * @param string $syncExternalId
     * @param \ArrayType\ArrayOfChangeContactGroupParameters $groups
     * @param \ArrayType\ArrayOfChangeContactTagParameters $tags
     * @param \ArrayType\ArrayOfChangeContactOptInListParameters $optInLists
     * @param \ArrayType\ArrayOfEditContactCustomFieldParameters $customFields
     */
    public function __construct($prefix_Id = null, $suffix_Id = null, $birthDate = null, $gender = null, $languagePreference = null, $mailOptIn = null, $emailOptIn = null, $phoneOptIn = null, $faxOptIn = null, $smsOptIn = null, $syncType_Id = null, $firstName = null, $middleName = null, $lastName = null, $primaryAddressStreet1 = null, $primaryAddressStreet2 = null, $primaryAddressCity = null, $primaryAddressState = null, $primaryAddressPostalCode = null, $primaryAddressCountry = null, $primaryEmailAddress = null, $primaryPhone = null, $primaryFax = null, $primarySms = null, $syncExternalId = null, \ArrayType\ArrayOfChangeContactGroupParameters $groups = null, \ArrayType\ArrayOfChangeContactTagParameters $tags = null, \ArrayType\ArrayOfChangeContactOptInListParameters $optInLists = null, \ArrayType\ArrayOfEditContactCustomFieldParameters $customFields = null)
    {
        $this
            ->setPrefix_Id($prefix_Id)
            ->setSuffix_Id($suffix_Id)
            ->setBirthDate($birthDate)
            ->setGender($gender)
            ->setLanguagePreference($languagePreference)
            ->setMailOptIn($mailOptIn)
            ->setEmailOptIn($emailOptIn)
            ->setPhoneOptIn($phoneOptIn)
            ->setFaxOptIn($faxOptIn)
            ->setSmsOptIn($smsOptIn)
            ->setSyncType_Id($syncType_Id)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName)
            ->setPrimaryAddressStreet1($primaryAddressStreet1)
            ->setPrimaryAddressStreet2($primaryAddressStreet2)
            ->setPrimaryAddressCity($primaryAddressCity)
            ->setPrimaryAddressState($primaryAddressState)
            ->setPrimaryAddressPostalCode($primaryAddressPostalCode)
            ->setPrimaryAddressCountry($primaryAddressCountry)
            ->setPrimaryEmailAddress($primaryEmailAddress)
            ->setPrimaryPhone($primaryPhone)
            ->setPrimaryFax($primaryFax)
            ->setPrimarySms($primarySms)
            ->setSyncExternalId($syncExternalId)
            ->setGroups($groups)
            ->setTags($tags)
            ->setOptInLists($optInLists)
            ->setCustomFields($customFields);
    }
    /**
     * Get Prefix_Id value
     * @return int
     */
    public function getPrefix_Id()
    {
        return $this->Prefix_Id;
    }
    /**
     * Set Prefix_Id value
     * @param int $prefix_Id
     * @return \StructType\EditPersonParameters
     */
    public function setPrefix_Id($prefix_Id = null)
    {
        // validation for constraint: int
        if (!is_null($prefix_Id) && !is_numeric($prefix_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($prefix_Id)), __LINE__);
        }
        $this->Prefix_Id = $prefix_Id;
        return $this;
    }
    /**
     * Get Suffix_Id value
     * @return int
     */
    public function getSuffix_Id()
    {
        return $this->Suffix_Id;
    }
    /**
     * Set Suffix_Id value
     * @param int $suffix_Id
     * @return \StructType\EditPersonParameters
     */
    public function setSuffix_Id($suffix_Id = null)
    {
        // validation for constraint: int
        if (!is_null($suffix_Id) && !is_numeric($suffix_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($suffix_Id)), __LINE__);
        }
        $this->Suffix_Id = $suffix_Id;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\EditPersonParameters
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get Gender value
     * @return string
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @uses \EnumType\Genders::valueIsValid()
     * @uses \EnumType\Genders::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\EditPersonParameters
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Genders::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $gender, implode(', ', \EnumType\Genders::getValidValues())), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get LanguagePreference value
     * @return string
     */
    public function getLanguagePreference()
    {
        return $this->LanguagePreference;
    }
    /**
     * Set LanguagePreference value
     * @uses \EnumType\LanguagePreferences::valueIsValid()
     * @uses \EnumType\LanguagePreferences::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $languagePreference
     * @return \StructType\EditPersonParameters
     */
    public function setLanguagePreference($languagePreference = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LanguagePreferences::valueIsValid($languagePreference)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $languagePreference, implode(', ', \EnumType\LanguagePreferences::getValidValues())), __LINE__);
        }
        $this->LanguagePreference = $languagePreference;
        return $this;
    }
    /**
     * Get MailOptIn value
     * @return bool
     */
    public function getMailOptIn()
    {
        return $this->MailOptIn;
    }
    /**
     * Set MailOptIn value
     * @param bool $mailOptIn
     * @return \StructType\EditPersonParameters
     */
    public function setMailOptIn($mailOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($mailOptIn) && !is_bool($mailOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mailOptIn)), __LINE__);
        }
        $this->MailOptIn = $mailOptIn;
        return $this;
    }
    /**
     * Get EmailOptIn value
     * @return bool
     */
    public function getEmailOptIn()
    {
        return $this->EmailOptIn;
    }
    /**
     * Set EmailOptIn value
     * @param bool $emailOptIn
     * @return \StructType\EditPersonParameters
     */
    public function setEmailOptIn($emailOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailOptIn) && !is_bool($emailOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($emailOptIn)), __LINE__);
        }
        $this->EmailOptIn = $emailOptIn;
        return $this;
    }
    /**
     * Get PhoneOptIn value
     * @return bool
     */
    public function getPhoneOptIn()
    {
        return $this->PhoneOptIn;
    }
    /**
     * Set PhoneOptIn value
     * @param bool $phoneOptIn
     * @return \StructType\EditPersonParameters
     */
    public function setPhoneOptIn($phoneOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($phoneOptIn) && !is_bool($phoneOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($phoneOptIn)), __LINE__);
        }
        $this->PhoneOptIn = $phoneOptIn;
        return $this;
    }
    /**
     * Get FaxOptIn value
     * @return bool
     */
    public function getFaxOptIn()
    {
        return $this->FaxOptIn;
    }
    /**
     * Set FaxOptIn value
     * @param bool $faxOptIn
     * @return \StructType\EditPersonParameters
     */
    public function setFaxOptIn($faxOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($faxOptIn) && !is_bool($faxOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($faxOptIn)), __LINE__);
        }
        $this->FaxOptIn = $faxOptIn;
        return $this;
    }
    /**
     * Get SmsOptIn value
     * @return bool
     */
    public function getSmsOptIn()
    {
        return $this->SmsOptIn;
    }
    /**
     * Set SmsOptIn value
     * @param bool $smsOptIn
     * @return \StructType\EditPersonParameters
     */
    public function setSmsOptIn($smsOptIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($smsOptIn) && !is_bool($smsOptIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($smsOptIn)), __LINE__);
        }
        $this->SmsOptIn = $smsOptIn;
        return $this;
    }
    /**
     * Get SyncType_Id value
     * @return int
     */
    public function getSyncType_Id()
    {
        return $this->SyncType_Id;
    }
    /**
     * Set SyncType_Id value
     * @param int $syncType_Id
     * @return \StructType\EditPersonParameters
     */
    public function setSyncType_Id($syncType_Id = null)
    {
        // validation for constraint: int
        if (!is_null($syncType_Id) && !is_numeric($syncType_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($syncType_Id)), __LINE__);
        }
        $this->SyncType_Id = $syncType_Id;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\EditPersonParameters
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\EditPersonParameters
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\EditPersonParameters
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get PrimaryAddressStreet1 value
     * @return string|null
     */
    public function getPrimaryAddressStreet1()
    {
        return $this->PrimaryAddressStreet1;
    }
    /**
     * Set PrimaryAddressStreet1 value
     * @param string $primaryAddressStreet1
     * @return \StructType\EditPersonParameters
     */
    public function setPrimaryAddressStreet1($primaryAddressStreet1 = null)
    {
        // validation for constraint: string
        if (!is_null($primaryAddressStreet1) && !is_string($primaryAddressStreet1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryAddressStreet1)), __LINE__);
        }
        $this->PrimaryAddressStreet1 = $primaryAddressStreet1;
        return $this;
    }
    /**
     * Get PrimaryAddressStreet2 value
     * @return string|null
     */
    public function getPrimaryAddressStreet2()
    {
        return $this->PrimaryAddressStreet2;
    }
    /**
     * Set PrimaryAddressStreet2 value
     * @param string $primaryAddressStreet2
     * @return \StructType\EditPersonParameters
     */
    public function setPrimaryAddressStreet2($primaryAddressStreet2 = null)
    {
        // validation for constraint: string
        if (!is_null($primaryAddressStreet2) && !is_string($primaryAddressStreet2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryAddressStreet2)), __LINE__);
        }
        $this->PrimaryAddressStreet2 = $primaryAddressStreet2;
        return $this;
    }
    /**
     * Get PrimaryAddressCity value
     * @return string|null
     */
    public function getPrimaryAddressCity()
    {
        return $this->PrimaryAddressCity;
    }
    /**
     * Set PrimaryAddressCity value
     * @param string $primaryAddressCity
     * @return \StructType\EditPersonParameters
     */
    public function setPrimaryAddressCity($primaryAddressCity = null)
    {
        // validation for constraint: string
        if (!is_null($primaryAddressCity) && !is_string($primaryAddressCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryAddressCity)), __LINE__);
        }
        $this->PrimaryAddressCity = $primaryAddressCity;
        return $this;
    }
    /**
     * Get PrimaryAddressState value
     * @return string|null
     */
    public function getPrimaryAddressState()
    {
        return $this->PrimaryAddressState;
    }
    /**
     * Set PrimaryAddressState value
     * @param string $primaryAddressState
     * @return \StructType\EditPersonParameters
     */
    public function setPrimaryAddressState($primaryAddressState = null)
    {
        // validation for constraint: string
        if (!is_null($primaryAddressState) && !is_string($primaryAddressState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryAddressState)), __LINE__);
        }
        $this->PrimaryAddressState = $primaryAddressState;
        return $this;
    }
    /**
     * Get PrimaryAddressPostalCode value
     * @return string|null
     */
    public function getPrimaryAddressPostalCode()
    {
        return $this->PrimaryAddressPostalCode;
    }
    /**
     * Set PrimaryAddressPostalCode value
     * @param string $primaryAddressPostalCode
     * @return \StructType\EditPersonParameters
     */
    public function setPrimaryAddressPostalCode($primaryAddressPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($primaryAddressPostalCode) && !is_string($primaryAddressPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryAddressPostalCode)), __LINE__);
        }
        $this->PrimaryAddressPostalCode = $primaryAddressPostalCode;
        return $this;
    }
    /**
     * Get PrimaryAddressCountry value
     * @return string|null
     */
    public function getPrimaryAddressCountry()
    {
        return $this->PrimaryAddressCountry;
    }
    /**
     * Set PrimaryAddressCountry value
     * @param string $primaryAddressCountry
     * @return \StructType\EditPersonParameters
     */
    public function setPrimaryAddressCountry($primaryAddressCountry = null)
    {
        // validation for constraint: string
        if (!is_null($primaryAddressCountry) && !is_string($primaryAddressCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryAddressCountry)), __LINE__);
        }
        $this->PrimaryAddressCountry = $primaryAddressCountry;
        return $this;
    }
    /**
     * Get PrimaryEmailAddress value
     * @return string|null
     */
    public function getPrimaryEmailAddress()
    {
        return $this->PrimaryEmailAddress;
    }
    /**
     * Set PrimaryEmailAddress value
     * @param string $primaryEmailAddress
     * @return \StructType\EditPersonParameters
     */
    public function setPrimaryEmailAddress($primaryEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryEmailAddress) && !is_string($primaryEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryEmailAddress)), __LINE__);
        }
        $this->PrimaryEmailAddress = $primaryEmailAddress;
        return $this;
    }
    /**
     * Get PrimaryPhone value
     * @return string|null
     */
    public function getPrimaryPhone()
    {
        return $this->PrimaryPhone;
    }
    /**
     * Set PrimaryPhone value
     * @param string $primaryPhone
     * @return \StructType\EditPersonParameters
     */
    public function setPrimaryPhone($primaryPhone = null)
    {
        // validation for constraint: string
        if (!is_null($primaryPhone) && !is_string($primaryPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryPhone)), __LINE__);
        }
        $this->PrimaryPhone = $primaryPhone;
        return $this;
    }
    /**
     * Get PrimaryFax value
     * @return string|null
     */
    public function getPrimaryFax()
    {
        return $this->PrimaryFax;
    }
    /**
     * Set PrimaryFax value
     * @param string $primaryFax
     * @return \StructType\EditPersonParameters
     */
    public function setPrimaryFax($primaryFax = null)
    {
        // validation for constraint: string
        if (!is_null($primaryFax) && !is_string($primaryFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryFax)), __LINE__);
        }
        $this->PrimaryFax = $primaryFax;
        return $this;
    }
    /**
     * Get PrimarySms value
     * @return string|null
     */
    public function getPrimarySms()
    {
        return $this->PrimarySms;
    }
    /**
     * Set PrimarySms value
     * @param string $primarySms
     * @return \StructType\EditPersonParameters
     */
    public function setPrimarySms($primarySms = null)
    {
        // validation for constraint: string
        if (!is_null($primarySms) && !is_string($primarySms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primarySms)), __LINE__);
        }
        $this->PrimarySms = $primarySms;
        return $this;
    }
    /**
     * Get SyncExternalId value
     * @return string|null
     */
    public function getSyncExternalId()
    {
        return $this->SyncExternalId;
    }
    /**
     * Set SyncExternalId value
     * @param string $syncExternalId
     * @return \StructType\EditPersonParameters
     */
    public function setSyncExternalId($syncExternalId = null)
    {
        // validation for constraint: string
        if (!is_null($syncExternalId) && !is_string($syncExternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($syncExternalId)), __LINE__);
        }
        $this->SyncExternalId = $syncExternalId;
        return $this;
    }
    /**
     * Get Groups value
     * @return \ArrayType\ArrayOfChangeContactGroupParameters|null
     */
    public function getGroups()
    {
        return $this->Groups;
    }
    /**
     * Set Groups value
     * @param \ArrayType\ArrayOfChangeContactGroupParameters $groups
     * @return \StructType\EditPersonParameters
     */
    public function setGroups(\ArrayType\ArrayOfChangeContactGroupParameters $groups = null)
    {
        $this->Groups = $groups;
        return $this;
    }
    /**
     * Get Tags value
     * @return \ArrayType\ArrayOfChangeContactTagParameters|null
     */
    public function getTags()
    {
        return $this->Tags;
    }
    /**
     * Set Tags value
     * @param \ArrayType\ArrayOfChangeContactTagParameters $tags
     * @return \StructType\EditPersonParameters
     */
    public function setTags(\ArrayType\ArrayOfChangeContactTagParameters $tags = null)
    {
        $this->Tags = $tags;
        return $this;
    }
    /**
     * Get OptInLists value
     * @return \ArrayType\ArrayOfChangeContactOptInListParameters|null
     */
    public function getOptInLists()
    {
        return $this->OptInLists;
    }
    /**
     * Set OptInLists value
     * @param \ArrayType\ArrayOfChangeContactOptInListParameters $optInLists
     * @return \StructType\EditPersonParameters
     */
    public function setOptInLists(\ArrayType\ArrayOfChangeContactOptInListParameters $optInLists = null)
    {
        $this->OptInLists = $optInLists;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \ArrayType\ArrayOfEditContactCustomFieldParameters|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \ArrayType\ArrayOfEditContactCustomFieldParameters $customFields
     * @return \StructType\EditPersonParameters
     */
    public function setCustomFields(\ArrayType\ArrayOfEditContactCustomFieldParameters $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditPersonParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
