<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditPaymentProfileParameters StructType
 * @subpackage Structs
 */
class EditPaymentProfileParameters extends EditRecordParameters
{
    /**
     * The IsPreferredPaymentProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsPreferredPaymentProfile;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateContactParameters
     */
    public $Contact;
    /**
     * The CreditCardInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CreditCardParameters
     */
    public $CreditCardInfo;
    /**
     * The PaymentBillingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentBillingContactParameters
     */
    public $PaymentBillingInfo;
    /**
     * Constructor method for EditPaymentProfileParameters
     * @uses EditPaymentProfileParameters::setIsPreferredPaymentProfile()
     * @uses EditPaymentProfileParameters::setContact()
     * @uses EditPaymentProfileParameters::setCreditCardInfo()
     * @uses EditPaymentProfileParameters::setPaymentBillingInfo()
     * @param bool $isPreferredPaymentProfile
     * @param \StructType\FindOrCreateContactParameters $contact
     * @param \StructType\CreditCardParameters $creditCardInfo
     * @param \StructType\PaymentBillingContactParameters $paymentBillingInfo
     */
    public function __construct($isPreferredPaymentProfile = null, \StructType\FindOrCreateContactParameters $contact = null, \StructType\CreditCardParameters $creditCardInfo = null, \StructType\PaymentBillingContactParameters $paymentBillingInfo = null)
    {
        $this
            ->setIsPreferredPaymentProfile($isPreferredPaymentProfile)
            ->setContact($contact)
            ->setCreditCardInfo($creditCardInfo)
            ->setPaymentBillingInfo($paymentBillingInfo);
    }
    /**
     * Get IsPreferredPaymentProfile value
     * @return bool
     */
    public function getIsPreferredPaymentProfile()
    {
        return $this->IsPreferredPaymentProfile;
    }
    /**
     * Set IsPreferredPaymentProfile value
     * @param bool $isPreferredPaymentProfile
     * @return \StructType\EditPaymentProfileParameters
     */
    public function setIsPreferredPaymentProfile($isPreferredPaymentProfile = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPreferredPaymentProfile) && !is_bool($isPreferredPaymentProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPreferredPaymentProfile)), __LINE__);
        }
        $this->IsPreferredPaymentProfile = $isPreferredPaymentProfile;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\FindOrCreateContactParameters $contact
     * @return \StructType\EditPaymentProfileParameters
     */
    public function setContact(\StructType\FindOrCreateContactParameters $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get CreditCardInfo value
     * @return \StructType\CreditCardParameters|null
     */
    public function getCreditCardInfo()
    {
        return $this->CreditCardInfo;
    }
    /**
     * Set CreditCardInfo value
     * @param \StructType\CreditCardParameters $creditCardInfo
     * @return \StructType\EditPaymentProfileParameters
     */
    public function setCreditCardInfo(\StructType\CreditCardParameters $creditCardInfo = null)
    {
        $this->CreditCardInfo = $creditCardInfo;
        return $this;
    }
    /**
     * Get PaymentBillingInfo value
     * @return \StructType\PaymentBillingContactParameters|null
     */
    public function getPaymentBillingInfo()
    {
        return $this->PaymentBillingInfo;
    }
    /**
     * Set PaymentBillingInfo value
     * @param \StructType\PaymentBillingContactParameters $paymentBillingInfo
     * @return \StructType\EditPaymentProfileParameters
     */
    public function setPaymentBillingInfo(\StructType\PaymentBillingContactParameters $paymentBillingInfo = null)
    {
        $this->PaymentBillingInfo = $paymentBillingInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditPaymentProfileParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
