<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatePagingQuery StructType
 * @subpackage Structs
 */
class DatePagingQuery extends PagingQuery
{
    /**
     * The DateCreatedFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateCreatedFrom;
    /**
     * The DateCreatedTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateCreatedTo;
    /**
     * Constructor method for DatePagingQuery
     * @uses DatePagingQuery::setDateCreatedFrom()
     * @uses DatePagingQuery::setDateCreatedTo()
     * @param string $dateCreatedFrom
     * @param string $dateCreatedTo
     */
    public function __construct($dateCreatedFrom = null, $dateCreatedTo = null)
    {
        $this
            ->setDateCreatedFrom($dateCreatedFrom)
            ->setDateCreatedTo($dateCreatedTo);
    }
    /**
     * Get DateCreatedFrom value
     * @return string
     */
    public function getDateCreatedFrom()
    {
        return $this->DateCreatedFrom;
    }
    /**
     * Set DateCreatedFrom value
     * @param string $dateCreatedFrom
     * @return \StructType\DatePagingQuery
     */
    public function setDateCreatedFrom($dateCreatedFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreatedFrom) && !is_string($dateCreatedFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateCreatedFrom)), __LINE__);
        }
        $this->DateCreatedFrom = $dateCreatedFrom;
        return $this;
    }
    /**
     * Get DateCreatedTo value
     * @return string
     */
    public function getDateCreatedTo()
    {
        return $this->DateCreatedTo;
    }
    /**
     * Set DateCreatedTo value
     * @param string $dateCreatedTo
     * @return \StructType\DatePagingQuery
     */
    public function setDateCreatedTo($dateCreatedTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreatedTo) && !is_string($dateCreatedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateCreatedTo)), __LINE__);
        }
        $this->DateCreatedTo = $dateCreatedTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatePagingQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
