<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateSustainerResponse StructType
 * @subpackage Structs
 */
class CreateSustainerResponse extends IntegrationApiRecordActionResponse
{
    /**
     * The Payment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProcessPaymentResponse
     */
    public $Payment;
    /**
     * The CreateSustainerResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CreateSustainerResponse
     */
    public $CreateSustainerResult;
    /**
     * Constructor method for CreateSustainerResponse
     * @uses CreateSustainerResponse::setPayment()
     * @uses CreateSustainerResponse::setCreateSustainerResult()
     * @param \StructType\ProcessPaymentResponse $payment
     * @param \StructType\CreateSustainerResponse $createSustainerResult
     */
    public function __construct(\StructType\ProcessPaymentResponse $payment = null, \StructType\CreateSustainerResponse $createSustainerResult = null)
    {
        $this
            ->setPayment($payment)
            ->setCreateSustainerResult($createSustainerResult);
    }
    /**
     * Get Payment value
     * @return \StructType\ProcessPaymentResponse|null
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param \StructType\ProcessPaymentResponse $payment
     * @return \StructType\CreateSustainerResponse
     */
    public function setPayment(\StructType\ProcessPaymentResponse $payment = null)
    {
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Get CreateSustainerResult value
     * @return \StructType\CreateSustainerResponse|null
     */
    public function getCreateSustainerResult()
    {
        return $this->CreateSustainerResult;
    }
    /**
     * Set CreateSustainerResult value
     * @param \StructType\CreateSustainerResponse $createSustainerResult
     * @return \StructType\CreateSustainerResponse
     */
    public function setCreateSustainerResult(\StructType\CreateSustainerResponse $createSustainerResult = null)
    {
        $this->CreateSustainerResult = $createSustainerResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateSustainerResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
