<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactUpdateActionParameters StructType
 * @subpackage Structs
 */
class ContactUpdateActionParameters extends SubParameters
{
    /**
     * The CopyName
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $CopyName;
    /**
     * The AddressCopyMode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $AddressCopyMode;
    /**
     * The PhoneCopyMode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PhoneCopyMode;
    /**
     * Constructor method for ContactUpdateActionParameters
     * @uses ContactUpdateActionParameters::setCopyName()
     * @uses ContactUpdateActionParameters::setAddressCopyMode()
     * @uses ContactUpdateActionParameters::setPhoneCopyMode()
     * @param bool $copyName
     * @param string $addressCopyMode
     * @param string $phoneCopyMode
     */
    public function __construct($copyName = null, $addressCopyMode = null, $phoneCopyMode = null)
    {
        $this
            ->setCopyName($copyName)
            ->setAddressCopyMode($addressCopyMode)
            ->setPhoneCopyMode($phoneCopyMode);
    }
    /**
     * Get CopyName value
     * @return bool
     */
    public function getCopyName()
    {
        return $this->CopyName;
    }
    /**
     * Set CopyName value
     * @param bool $copyName
     * @return \StructType\ContactUpdateActionParameters
     */
    public function setCopyName($copyName = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyName) && !is_bool($copyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($copyName)), __LINE__);
        }
        $this->CopyName = $copyName;
        return $this;
    }
    /**
     * Get AddressCopyMode value
     * @return string
     */
    public function getAddressCopyMode()
    {
        return $this->AddressCopyMode;
    }
    /**
     * Set AddressCopyMode value
     * @uses \EnumType\ContactInfoCopyModes::valueIsValid()
     * @uses \EnumType\ContactInfoCopyModes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $addressCopyMode
     * @return \StructType\ContactUpdateActionParameters
     */
    public function setAddressCopyMode($addressCopyMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContactInfoCopyModes::valueIsValid($addressCopyMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $addressCopyMode, implode(', ', \EnumType\ContactInfoCopyModes::getValidValues())), __LINE__);
        }
        $this->AddressCopyMode = $addressCopyMode;
        return $this;
    }
    /**
     * Get PhoneCopyMode value
     * @return string
     */
    public function getPhoneCopyMode()
    {
        return $this->PhoneCopyMode;
    }
    /**
     * Set PhoneCopyMode value
     * @uses \EnumType\ContactInfoCopyModes::valueIsValid()
     * @uses \EnumType\ContactInfoCopyModes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneCopyMode
     * @return \StructType\ContactUpdateActionParameters
     */
    public function setPhoneCopyMode($phoneCopyMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContactInfoCopyModes::valueIsValid($phoneCopyMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneCopyMode, implode(', ', \EnumType\ContactInfoCopyModes::getValidValues())), __LINE__);
        }
        $this->PhoneCopyMode = $phoneCopyMode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactUpdateActionParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
