<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeLogRecord StructType
 * @subpackage Structs
 */
class ChangeLogRecord extends DataRecord
{
    /**
     * The Record_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Record_Id;
    /**
     * The Object_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Object_Id;
    /**
     * The App_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $App_Id;
    /**
     * The User_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $User_Id;
    /**
     * The ApiUser_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $ApiUser_Id;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChangeLogType
     */
    public $Type;
    /**
     * Constructor method for ChangeLogRecord
     * @uses ChangeLogRecord::setRecord_Id()
     * @uses ChangeLogRecord::setObject_Id()
     * @uses ChangeLogRecord::setApp_Id()
     * @uses ChangeLogRecord::setUser_Id()
     * @uses ChangeLogRecord::setApiUser_Id()
     * @uses ChangeLogRecord::setType()
     * @param int $record_Id
     * @param int $object_Id
     * @param int $app_Id
     * @param int $user_Id
     * @param int $apiUser_Id
     * @param \StructType\ChangeLogType $type
     */
    public function __construct($record_Id = null, $object_Id = null, $app_Id = null, $user_Id = null, $apiUser_Id = null, \StructType\ChangeLogType $type = null)
    {
        $this
            ->setRecord_Id($record_Id)
            ->setObject_Id($object_Id)
            ->setApp_Id($app_Id)
            ->setUser_Id($user_Id)
            ->setApiUser_Id($apiUser_Id)
            ->setType($type);
    }
    /**
     * Get Record_Id value
     * @return int
     */
    public function getRecord_Id()
    {
        return $this->Record_Id;
    }
    /**
     * Set Record_Id value
     * @param int $record_Id
     * @return \StructType\ChangeLogRecord
     */
    public function setRecord_Id($record_Id = null)
    {
        // validation for constraint: int
        if (!is_null($record_Id) && !is_numeric($record_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($record_Id)), __LINE__);
        }
        $this->Record_Id = $record_Id;
        return $this;
    }
    /**
     * Get Object_Id value
     * @return int
     */
    public function getObject_Id()
    {
        return $this->Object_Id;
    }
    /**
     * Set Object_Id value
     * @param int $object_Id
     * @return \StructType\ChangeLogRecord
     */
    public function setObject_Id($object_Id = null)
    {
        // validation for constraint: int
        if (!is_null($object_Id) && !is_numeric($object_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($object_Id)), __LINE__);
        }
        $this->Object_Id = $object_Id;
        return $this;
    }
    /**
     * Get App_Id value
     * @return int
     */
    public function getApp_Id()
    {
        return $this->App_Id;
    }
    /**
     * Set App_Id value
     * @param int $app_Id
     * @return \StructType\ChangeLogRecord
     */
    public function setApp_Id($app_Id = null)
    {
        // validation for constraint: int
        if (!is_null($app_Id) && !is_numeric($app_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($app_Id)), __LINE__);
        }
        $this->App_Id = $app_Id;
        return $this;
    }
    /**
     * Get User_Id value
     * @return int
     */
    public function getUser_Id()
    {
        return $this->User_Id;
    }
    /**
     * Set User_Id value
     * @param int $user_Id
     * @return \StructType\ChangeLogRecord
     */
    public function setUser_Id($user_Id = null)
    {
        // validation for constraint: int
        if (!is_null($user_Id) && !is_numeric($user_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($user_Id)), __LINE__);
        }
        $this->User_Id = $user_Id;
        return $this;
    }
    /**
     * Get ApiUser_Id value
     * @return int
     */
    public function getApiUser_Id()
    {
        return $this->ApiUser_Id;
    }
    /**
     * Set ApiUser_Id value
     * @param int $apiUser_Id
     * @return \StructType\ChangeLogRecord
     */
    public function setApiUser_Id($apiUser_Id = null)
    {
        // validation for constraint: int
        if (!is_null($apiUser_Id) && !is_numeric($apiUser_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($apiUser_Id)), __LINE__);
        }
        $this->ApiUser_Id = $apiUser_Id;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\ChangeLogType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\ChangeLogType $type
     * @return \StructType\ChangeLogRecord
     */
    public function setType(\StructType\ChangeLogType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChangeLogRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
