<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingInfoCollection StructType
 * @subpackage Structs
 */
class BillingInfoCollection extends GroupedProperties
{
    /**
     * The AddressStreet1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressStreet1;
    /**
     * The AddressStreet2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressStreet2;
    /**
     * The AddressCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressCity;
    /**
     * The AddressStateProvince
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressStateProvince;
    /**
     * The AddressPostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressPostalCode;
    /**
     * The AddressStateCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressStateCountry;
    /**
     * Constructor method for BillingInfoCollection
     * @uses BillingInfoCollection::setAddressStreet1()
     * @uses BillingInfoCollection::setAddressStreet2()
     * @uses BillingInfoCollection::setAddressCity()
     * @uses BillingInfoCollection::setAddressStateProvince()
     * @uses BillingInfoCollection::setAddressPostalCode()
     * @uses BillingInfoCollection::setAddressStateCountry()
     * @param string $addressStreet1
     * @param string $addressStreet2
     * @param string $addressCity
     * @param string $addressStateProvince
     * @param string $addressPostalCode
     * @param string $addressStateCountry
     */
    public function __construct($addressStreet1 = null, $addressStreet2 = null, $addressCity = null, $addressStateProvince = null, $addressPostalCode = null, $addressStateCountry = null)
    {
        $this
            ->setAddressStreet1($addressStreet1)
            ->setAddressStreet2($addressStreet2)
            ->setAddressCity($addressCity)
            ->setAddressStateProvince($addressStateProvince)
            ->setAddressPostalCode($addressPostalCode)
            ->setAddressStateCountry($addressStateCountry);
    }
    /**
     * Get AddressStreet1 value
     * @return string|null
     */
    public function getAddressStreet1()
    {
        return $this->AddressStreet1;
    }
    /**
     * Set AddressStreet1 value
     * @param string $addressStreet1
     * @return \StructType\BillingInfoCollection
     */
    public function setAddressStreet1($addressStreet1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressStreet1) && !is_string($addressStreet1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressStreet1)), __LINE__);
        }
        $this->AddressStreet1 = $addressStreet1;
        return $this;
    }
    /**
     * Get AddressStreet2 value
     * @return string|null
     */
    public function getAddressStreet2()
    {
        return $this->AddressStreet2;
    }
    /**
     * Set AddressStreet2 value
     * @param string $addressStreet2
     * @return \StructType\BillingInfoCollection
     */
    public function setAddressStreet2($addressStreet2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressStreet2) && !is_string($addressStreet2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressStreet2)), __LINE__);
        }
        $this->AddressStreet2 = $addressStreet2;
        return $this;
    }
    /**
     * Get AddressCity value
     * @return string|null
     */
    public function getAddressCity()
    {
        return $this->AddressCity;
    }
    /**
     * Set AddressCity value
     * @param string $addressCity
     * @return \StructType\BillingInfoCollection
     */
    public function setAddressCity($addressCity = null)
    {
        // validation for constraint: string
        if (!is_null($addressCity) && !is_string($addressCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressCity)), __LINE__);
        }
        $this->AddressCity = $addressCity;
        return $this;
    }
    /**
     * Get AddressStateProvince value
     * @return string|null
     */
    public function getAddressStateProvince()
    {
        return $this->AddressStateProvince;
    }
    /**
     * Set AddressStateProvince value
     * @param string $addressStateProvince
     * @return \StructType\BillingInfoCollection
     */
    public function setAddressStateProvince($addressStateProvince = null)
    {
        // validation for constraint: string
        if (!is_null($addressStateProvince) && !is_string($addressStateProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressStateProvince)), __LINE__);
        }
        $this->AddressStateProvince = $addressStateProvince;
        return $this;
    }
    /**
     * Get AddressPostalCode value
     * @return string|null
     */
    public function getAddressPostalCode()
    {
        return $this->AddressPostalCode;
    }
    /**
     * Set AddressPostalCode value
     * @param string $addressPostalCode
     * @return \StructType\BillingInfoCollection
     */
    public function setAddressPostalCode($addressPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($addressPostalCode) && !is_string($addressPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressPostalCode)), __LINE__);
        }
        $this->AddressPostalCode = $addressPostalCode;
        return $this;
    }
    /**
     * Get AddressStateCountry value
     * @return string|null
     */
    public function getAddressStateCountry()
    {
        return $this->AddressStateCountry;
    }
    /**
     * Set AddressStateCountry value
     * @param string $addressStateCountry
     * @return \StructType\BillingInfoCollection
     */
    public function setAddressStateCountry($addressStateCountry = null)
    {
        // validation for constraint: string
        if (!is_null($addressStateCountry) && !is_string($addressStateCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressStateCountry)), __LINE__);
        }
        $this->AddressStateCountry = $addressStateCountry;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BillingInfoCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
